
#include "stdAfx.h"
#include "CFigure.h"
#include "math.h"
IMPLEMENT_SERIAL(CFigure, CObject, VERSION_NUMBER)

CFigure::CFigure()
{
  mColor = RGB(0,0,0);
  mRect = CRect(20,20,80,80);
  mShape = CIRCLE;
  mStyle = NARROW;
  mRectNorm = CRect(20,20,80,80);
}

CFigure::CFigure(CRect& rectOccupied, shapeVal shape, styleVal style, COLORREF& color)
{
  mColor = color;
  mRect = rectOccupied;
  mRectNorm = rectOccupied;
  mRectNorm.NormalizeRect();
  mRectNorm.InflateRect(8,8);
  mRectNorm.OffsetRect(-3,3);//for some reason this works better
  mShape = shape;
  if((mShape == LINE || mShape == TEXT)&&(mStyle == FILL))
  {
    mStyle = NARROW;
  }
  else
    mStyle = style;
}
void CFigure::draw(CDC* aDC)
{
  draw(aDC, mColor);
}

void CFigure::draw(CDC* theDC, COLORREF specialColor)
{

  CPen mainPen;
  CBrush mainBrush;
  CPen* tempPen;
  CBrush* tempBrush;

  if(mStyle != FILL)
  {
   // mainPen.CreatePen(PS_SOLID, mStyle, mColor);
    mainPen.CreatePen(PS_SOLID, mStyle, specialColor);
  }
  else
  {
   // mainPen.CreatePen(PS_SOLID, NARROW, mColor);
    mainPen.CreatePen(PS_SOLID, NARROW, specialColor);
  }
  tempPen = static_cast<CPen*>(theDC->SelectObject(&mainPen));

 
  if(mStyle == FILL)
  {
    mainBrush.CreateSolidBrush(specialColor);
    tempBrush = static_cast<CBrush*> (theDC->SelectObject(&mainBrush));
  }
  else
    tempBrush = static_cast<CBrush*> (theDC->SelectStockObject(NULL_BRUSH));

  if(mShape == RECTANGLE)
    theDC->Rectangle(mRect);
  else if(mShape == CIRCLE)
  {
    CPoint a = CPoint(mRect.left, mRect.top);
    CPoint b = CPoint(mRect.right, mRect.bottom);
    CPoint c((a.x + b.x)/2, a.y);
    //theDC->Arc(a.x,a.y,b.x,b.y,c.x,c.y,c.x,c.y);
    theDC->Ellipse(mRect);
  }
  else if(mShape == LINE)
  {
    theDC->MoveTo(mRect.left, mRect.top);
    theDC->LineTo(mRect.right, mRect.bottom);
  }
  else if(mShape == TEXT)
  {
    CPen textPen;
    textPen.CreatePen(PS_DOT, 1, RGB(0,0,255));
    theDC->SelectObject(textPen);
    theDC->SelectStockObject(NULL_BRUSH);
    theDC->Rectangle(mRect);
  }
  else
  {
    //AfxMessageBox("Invalid Shape Selected!",0,0);
theDC->Rectangle(mRect);
  }
  
  theDC->SelectObject(tempPen);
  theDC->SelectObject(tempBrush);
}

bool CFigure::getOver(CPoint& thePoint)
{
  //CString areaDesc;
  //areaDesc.Format("Rect is topLeft(%d,%d) to bottomRight(%d,%d)", mRectNorm.left, mRectNorm.top, mRectNorm.right, mRectNorm.bottom);
  //AfxMessageBox(areaDesc, 0, 0);
 
  switch(mShape)
  {
  case CIRCLE:
    {
      double xDist = (mRectNorm.right - mRectNorm.left);
      double yDist = (mRectNorm.top - mRectNorm.bottom) ; 
      double xCoef = 1.0/(pow((xDist/2.0), 2));
      double yCoef = 1.0/(pow((yDist/2.0), 2));
      double xCenter = mRectNorm.left + xDist/(2.0);
      double yCenter = mRectNorm.top - yDist/(2.0);
      double circleFudge = mStyle == FILL ? 0.0 : mStyle/40.0;
      if(0.9 + circleFudge >= (xCoef*(thePoint.x - xCenter)*(thePoint.x - xCenter) + yCoef*(thePoint.y - yCenter)*(thePoint.y - yCenter)))
      {
        return true;
      }
      break;
    }
  case LINE:
    {
      if(((mRect.bottom - mRect.top) == 0) || ((mRect.right - mRect.left) == 0))
      {
        if(mRectNorm.PtInRect(thePoint))
        {
          return true;
        }
      }
      double slope = 1.0*(mRect.bottom - mRect.top)/(1.0*(mRect.right - mRect.left));
      double offset = mRect.top - slope*mRect.left;
      int XfudgeFactor = 0;
      int YfudgeFactor = 0;
      if(mStyle == NARROW)
      {
        if(slope > 10.0)
        {
          XfudgeFactor = mStyle + 7;
        }
        else if(slope < -8.0)
        {
          //Lines draw in this particular direction were hard to click on so I added the 
          //slope factor to make them easier to click on
          XfudgeFactor = -mStyle - 7 + 2*slope;
        }
        else
        {
          YfudgeFactor = mStyle + 7;
        }
      }
      else
      {
        if(slope > 10.0)
        {
          XfudgeFactor = mStyle/2 + 7;
        }
        else if(slope < -10.0)
        {
          XfudgeFactor = -mStyle/2 - 7;
        }
        else
        {
          YfudgeFactor = mStyle/2 + 7;
        }
      }
      if((thePoint.y + YfudgeFactor >= slope*(thePoint.x - XfudgeFactor) + offset)&&(thePoint.y - YfudgeFactor <= slope*(thePoint.x + XfudgeFactor) + offset)&&(mRectNorm.PtInRect(thePoint)))
      {
        return true;
      }
      break;
    }
  case RECTANGLE:
  case TEXT:
  default:
    {
    if(mRectNorm.PtInRect(thePoint))
      return true;
    }
  }

  return false;
}
void CFigure::move(CSize aSize)
{
  //aSize.cy = -aSize.cy;
  mRect += aSize;
  mRectNorm += aSize;
}

CRect CFigure::getRect()
{
  return mRectNorm;
}

shapeVal CFigure::getShape()
{
  return mShape;
}

void CFigure::setColor(COLORREF& theColor)
{
  mColor = theColor;
}

void CFigure::setRect(CRect& theRect)
{
  mRect = theRect;
}

void CFigure::setStyle(styleVal theStyle)
{
  mStyle = theStyle;
}
void CFigure::Serialize(CArchive& ar)
{

  int tempInt;
  if (ar.IsStoring())
	{
		ar << mRect << mRectNorm << mColor;
    ar << (int) mShape;
    ar << (int) mStyle;
	}
	else
	{
    ar >> mRect;
    ar >> mRectNorm;
    ar >> mColor;
    ar >> tempInt;
    mShape = static_cast<enum shapeVal> (tempInt);
    ar >> tempInt;
    mStyle = static_cast<enum styleVal> (tempInt);
	}  
}
