
#include "stdAfx.h"
#include "CText.h"
IMPLEMENT_SERIAL(CText, CFigure, VERSION_NUMBER)

//CText::CText()// : CFigure()
//{
  //Look at CText.h for initializer list including:
  //CFigure()
//  m_sText = "<empty>";
//}

CText::CText(CRect& aRect, shapeVal aShape, styleVal aStyle, 
             COLORREF& aColor, CString aString) 
             : CFigure(aRect, aShape, aStyle, aColor)
{
  m_sText = aString;
  m_nTextRatio = AVG_LETTER_RATIO*((double)m_sText.GetLength());
}

CString CText::getText()
{
  return m_sText;
}
void CText::draw(CDC* aDC)
{
  draw(aDC, mColor);
}
void CText::draw(CDC* aDC, COLORREF specialColor)
{
  aDC->SetTextColor(specialColor);
  CRect tempRect = mRect;
  fixRect(tempRect);
  aDC->SetBkMode(R2_NOP);

  //Adjusting the font to fit the reactangle
  //Setup do loop then adjust font.
  CFont aFont;
  CFont* oldFont;
  int textSizeFactor;
  int version_num = ::_winmajor;
  (version_num == 4) ? textSizeFactor = 6 : textSizeFactor = 4;
  //CString verStr;
  //verStr.Format("ver: %d", version_num);
  //AfxMessageBox(verStr,0,0);
  int numPoints = (tempRect.Height())*textSizeFactor;
  aFont.CreatePointFont(numPoints,FONT_NAME,aDC);
  oldFont = aDC->SelectObject(&aFont);
  CSize textExt = aDC->GetTextExtent(m_sText);
  aDC->DrawText(m_sText,tempRect,  DT_CENTER | DT_VCENTER);
  aDC->SelectObject(oldFont);
}

double CText::getTextRatio()
{
  return m_nTextRatio;
}

void CText::Serialize(CArchive &ar)
{
  int tempInt;
  if (ar.IsStoring())
	{
    ar << m_sText;
		ar << mRect << mRectNorm << mColor;
    ar << (int) mShape;
    ar << (int) mStyle;
	}
	else
	{
    ar >> m_sText;
    ar >> mRect;
    ar >> mRectNorm;
    ar >> mColor;
    ar >> tempInt;
    mShape = static_cast<enum shapeVal> (tempInt);
    ar >> tempInt;
    mStyle = static_cast<enum styleVal> (tempInt);
	} 
}

void CText::fixRect(CRect& aRect)
{
  int tempInt;
  if(aRect.bottom > aRect.top)
  {
    tempInt = aRect.bottom;
    aRect.bottom = aRect.top;
    aRect.top = tempInt;
  }
  if(aRect.right < aRect.left)
  {
    tempInt = aRect.right;
    aRect.right = aRect.left;
    aRect.left = tempInt;
  }
}

//draw
  //aDC->TextOut(mRect.left, mRect.top, m_sText);
//tempRect.NormalizeRect();
  //CString yada;
  //yada.Format("left:%d,top:%d,right:%d,bottom:%d", tempRect.left,tempRect.top,tempRect.right,tempRect.bottom);
  //AfxMessageBox(yada,0,0);
//  CPoint checkPoint = CPoint(tempRect.left , tempRect.top);
 // COLORREF backColor = aDC->GetPixel(checkPoint);
 // aDC->SetBkColor(backColor);

//serialize
//    if(getShape() == TEXT)
//      AfxMessageBox("Archive looks good",0,0);
//    else
//      AfxMessageBox("Archive looks bad",0,0);