// CoolDrawDoc.cpp : implementation of the CCoolDrawDoc class
//

#include "stdafx.h"
#include "CoolDraw.h"

#include "CoolDrawDoc.h"
#include "TextDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoolDrawDoc

IMPLEMENT_DYNCREATE(CCoolDrawDoc, CDocument)

BEGIN_MESSAGE_MAP(CCoolDrawDoc, CDocument)
	//{{AFX_MSG_MAP(CCoolDrawDoc)
	ON_COMMAND(ID_VIEW_ATTRIBUTE_LINE_NARROW, OnViewAttributeLineNarrow)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ATTRIBUTE_LINE_NARROW, OnUpdateViewAttributeLineNarrow)
	ON_COMMAND(ID_VIEW_ATTRIBUTE_LINE_MEDIUM, OnViewAttributeLineMedium)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ATTRIBUTE_LINE_MEDIUM, OnUpdateViewAttributeLineMedium)
	ON_COMMAND(ID_VIEW_ATTRIBUTE_LINE_THICK, OnViewAttributeLineThick)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ATTRIBUTE_LINE_THICK, OnUpdateViewAttributeLineThick)
	ON_COMMAND(ID_VIEW_ATTRIBUTE_LINE_FILL, OnViewAttributeLineFill)
	ON_UPDATE_COMMAND_UI(ID_VIEW_ATTRIBUTE_LINE_FILL, OnUpdateViewAttributeLineFill)
	ON_COMMAND(ID_SHAPE_CIRCLE, OnShapeCircle)
	ON_UPDATE_COMMAND_UI(ID_SHAPE_CIRCLE, OnUpdateShapeCircle)
	ON_COMMAND(ID_SHAPE_LINE, OnShapeLine)
	ON_UPDATE_COMMAND_UI(ID_SHAPE_LINE, OnUpdateShapeLine)
	ON_COMMAND(ID_SHAPE_RECTANGLE, OnShapeRectangle)
	ON_UPDATE_COMMAND_UI(ID_SHAPE_RECTANGLE, OnUpdateShapeRectangle)
	ON_COMMAND(ID_SHAPE_TEXT, OnShapeText)
	ON_UPDATE_COMMAND_UI(ID_SHAPE_TEXT, OnUpdateShapeText)
	ON_COMMAND(ID_VIEW_ATTRIBUTE_COLOR, OnViewAttributeColor)
	ON_COMMAND(ID_BUTTON32782, OnButton32782)
	ON_COMMAND(ID_BUTTON32783, OnButton32783)
	ON_COMMAND(ID_BUTTON32784, OnButton32784)
	ON_COMMAND(ID_BUTTON32785, OnButton32785)
	ON_COMMAND(ID_BUTTON32786, OnButton32786)
	ON_COMMAND(ID_BUTTON32788, OnButton32788)
	ON_UPDATE_COMMAND_UI(ID_BUTTON32786, OnUpdateButton32786)
	ON_UPDATE_COMMAND_UI(ID_BUTTON32788, OnUpdateButton32788)
	ON_COMMAND(IDC_QUEUE, OnQueue)
	ON_UPDATE_COMMAND_UI(IDC_QUEUE, OnUpdateQueue)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoolDrawDoc construction/destruction

CCoolDrawDoc::CCoolDrawDoc()
{
	// TODO: add one-time construction code here
  lineStyle = NARROW;
  currentShape = CIRCLE;
  currentColor = RGB(0,0,0);
  prevLStyle = lineStyle;
  prevShape = currentShape;
  returnToShape = currentShape;
  erasing = false;
  filling = false;
  QSelecting = true;
  showFloat = true;
  currentText = "";
}

CCoolDrawDoc::~CCoolDrawDoc()
{
  figureStoreArr.RemoveAll();
  selectedArr.RemoveAll();
}

BOOL CCoolDrawDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CCoolDrawDoc serialization

void CCoolDrawDoc::Serialize(CArchive& ar)
{
//  CFigure* tempFig;

//  figureStoreArr.Serialize(ar);
  int tempInt;
	if (ar.IsStoring())
	{
    figureStoreArr.Serialize(ar);
    ar << (int)lineStyle
      << (int)currentShape
      << currentColor
      << (int)prevLStyle
      << (int)prevShape;
    if(erasing)
      ar << 1;
    else
      ar << 0;
    if(filling)
      ar << 1;
    else
      ar << 0;
	}
	else
	{
    erasing = filling = false;
//    ar >> tempInt;
    figureStoreArr.RemoveAll();
    figureStoreArr.Serialize(ar);
    ar >> tempInt;
    lineStyle = static_cast<styleVal> (tempInt);
    ar >> tempInt;
    currentShape = static_cast<shapeVal> (tempInt);
    ar >> currentColor;
    ar >> tempInt;
    prevLStyle = static_cast<styleVal> (tempInt);
    ar >> tempInt;
    prevShape = static_cast<shapeVal> (tempInt);
    ar >> tempInt;
    if(tempInt == 1)
      erasing = true;
    ar >> tempInt;
    if(tempInt == 1)
      filling = true;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CCoolDrawDoc diagnostics

#ifdef _DEBUG
void CCoolDrawDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CCoolDrawDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCoolDrawDoc commands

void CCoolDrawDoc::OnViewAttributeLineNarrow() 
{
  lineStyle = NARROW;	
}

void CCoolDrawDoc::OnUpdateViewAttributeLineNarrow(CCmdUI* pCmdUI) 
{
	if(lineStyle == NARROW)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);
}

void CCoolDrawDoc::OnViewAttributeLineMedium() 
{
  lineStyle = MEDIUM;	
}

void CCoolDrawDoc::OnUpdateViewAttributeLineMedium(CCmdUI* pCmdUI) 
{
	if(lineStyle == MEDIUM)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);	
}

void CCoolDrawDoc::OnViewAttributeLineThick() 
{
  lineStyle = THICK;	
}

void CCoolDrawDoc::OnUpdateViewAttributeLineThick(CCmdUI* pCmdUI) 
{
	if(lineStyle == THICK)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);	
}

void CCoolDrawDoc::OnViewAttributeLineFill() 
{
  lineStyle = FILL;	
}

void CCoolDrawDoc::OnUpdateViewAttributeLineFill(CCmdUI* pCmdUI) 
{
	if(lineStyle == FILL)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);
}

void CCoolDrawDoc::OnShapeCircle() 
{
  currentShape = CIRCLE;	
  returnToShape = CIRCLE;
}

void CCoolDrawDoc::OnUpdateShapeCircle(CCmdUI* pCmdUI) 
{
	if(currentShape == CIRCLE)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);	
}

void CCoolDrawDoc::OnShapeLine() 
{
  currentShape = LINE;	
  returnToShape = LINE;
}

void CCoolDrawDoc::OnUpdateShapeLine(CCmdUI* pCmdUI) 
{
	if(currentShape == LINE)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);	
}

void CCoolDrawDoc::OnShapeRectangle() 
{
  currentShape = RECTANGLE;	
  returnToShape = RECTANGLE;
}

void CCoolDrawDoc::OnUpdateShapeRectangle(CCmdUI* pCmdUI) 
{
	if(currentShape == RECTANGLE)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);	
}

void CCoolDrawDoc::OnShapeText() 
{
  CTextDialog aTextDlg;

  aTextDlg.m_sDlgText = currentText;
//    aTextDlg.UpdateData(FALSE);
  
  if(aTextDlg.DoModal() == IDOK)
  {
    currentText = aTextDlg.m_sDlgText;
    currentShape = TEXT;
  }
}

void CCoolDrawDoc::OnUpdateShapeText(CCmdUI* pCmdUI) 
{
	if(currentShape == TEXT)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);	
}

bool CCoolDrawDoc::addFigure(CRect& occupiedRect)
{
  CFigure* tempFig;
  if(currentShape == TEXT)
    tempFig = new CText(occupiedRect, currentShape, lineStyle, currentColor, currentText);
  else
    tempFig = new CFigure(occupiedRect, currentShape, lineStyle, currentColor);
  figureStoreArr.AddTail(tempFig);
  SetModifiedFlag();
  return true;
}

bool CCoolDrawDoc::removeFigure(CFigure* fig2go)
{
  POSITION aPosition;
  aPosition = figureStoreArr.Find(fig2go);
  
  CFigure* tempFig = figureStoreArr.GetAt(aPosition);
  if(tempFig != NULL)
  {
    figureStoreArr.RemoveAt(aPosition);
    SetModifiedFlag();
  }
//    delete tempFig;
  return true;
}
bool CCoolDrawDoc::addSelected(CFigure* selFig)
{
  if(selFig == NULL)
    return false;
  selectedArr.AddHead(selFig);
  return true;
}

void CCoolDrawDoc::clearSelected()
{
  while(!selectedArr.IsEmpty())
  {
    selectedArr.RemoveHead();
  }
}

shapeVal CCoolDrawDoc::getShape()
{
  return currentShape;
}

styleVal CCoolDrawDoc::getStyle()
{
  return lineStyle;
}

void CCoolDrawDoc::OnViewAttributeColor() 
{
	CColorDialog theColor;
	theColor.DoModal();
	currentColor = theColor.GetColor();
}

COLORREF CCoolDrawDoc::getColor()
{
  return currentColor;

}

CString CCoolDrawDoc::getText()
{
  return currentText;
}

void CCoolDrawDoc::OnButton32782() 
{
  OnShapeCircle();
	
}

void CCoolDrawDoc::OnButton32783() 
{
  OnShapeRectangle();	
}

void CCoolDrawDoc::OnButton32784() 
{
  OnShapeLine();	
}

void CCoolDrawDoc::OnButton32785() 
{
  OnShapeText();	
}

void CCoolDrawDoc::OnButton32786() 
{
  erasing = !erasing;
  if(filling)
    filling = false;
  prevLStyle = lineStyle;
  prevShape = currentShape;	
}

void CCoolDrawDoc::OnButton32788() 
{
  filling = !filling;	
  if(erasing)
    erasing = false;
  prevLStyle = lineStyle;
  prevShape = currentShape;
}

bool CCoolDrawDoc::getErasing()
{
  return erasing;
}

bool CCoolDrawDoc::getFilling()
{
  return filling;
}

void CCoolDrawDoc::OnUpdateButton32786(CCmdUI* pCmdUI) 
{
  if((!erasing)||(lineStyle != prevLStyle)||(currentShape != prevShape))
  {
    erasing = false;
    pCmdUI->SetCheck(0);	
  }
  else
    pCmdUI->SetCheck();

}

void CCoolDrawDoc::OnUpdateButton32788(CCmdUI* pCmdUI) 
{
  if((!filling)||(lineStyle != prevLStyle)||(currentShape != prevShape))
  {
    filling = false;
    pCmdUI->SetCheck(0);
  }
  else
    pCmdUI->SetCheck();
}

void CCoolDrawDoc::setText(CString& aString)
{
  currentText = aString;
}

CRect CCoolDrawDoc::getDocExtent()
{
  CFigure* tempFig;
  CRect docExt(0,0,1,1);
  CRect tempRect(0,0,0,0);
  POSITION aPos = figureStoreArr.GetHeadPosition();
  while(aPos)
  {
    tempFig = figureStoreArr.GetNext(aPos);
    tempRect = tempFig->getRect();
    docExt.UnionRect(docExt, tempRect);
  }
  docExt.NormalizeRect();
  return docExt;
}
    
/*
void CCoolDrawDoc::OnViewFloatingbar() 
{
	// TODO: Add your command handler code here
//	CWnd* yada = 
 // CDocTemplate* yada =  this->GetDocTemplate();
 // CCoolDrawView* bog = yada->getRuntimeClass(CCoolDrawView);
  //HWND aHandle = GetWindowLong();
  //HWND bog = ::GetParent((this);
  //CWnd* yada1 = yada->GetParent();
  //yada->
  //showFloat = !showFloat;

}

void CCoolDrawDoc::OnUpdateViewFloatingbar(CCmdUI* pCmdUI) 
{
    if(showFloat)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);
  CString showIt;
  showIt.Format("called UI %d",showFloat);
  TRACE(showIt);

}
//serialize
//    int numFigs = figureStoreArr.GetCount();
//    ar << numFigs;
//    POSITION aPos = figureStoreArr.GetHeadPosition();
//    while(aPos)
//    {
//      tempFig = figureStoreArr.GetNext(aPos);
//      tempFig->Serialize(ar);
//    }
//    for(int i = 0; i < tempInt; i++)
//    {
//      tempFig = new CFigure();
//      tempFig->Serialize(ar);
//      figureStoreArr.AddTail(tempFig);
//    }
// OnShapeText

//  CWnd* yada = AfxGetMainWnd();
//  CMenu* fleeb = yada->GetMenu();
//  fleeb->CheckMenuItem(ID_SHAPE_RECTANGLE, 1);
//  CCmdUI* theUI = new CCmdUI();
//  theUI->m_nID = ID_SHAPE_TEXT;
//  theUI->m_nIndex = 3;
//  theUI->SetCheck(1);
  //theUI->DoUpdate(this, TRUE);

    //UINT nFlags;
  //fleeb->GetMenuState(ID_SHAPE_TEXT, nFlags);
  //OnUpdateShapeRectangle(
*/

void CCoolDrawDoc::OnQueue() 
{
  QSelecting = !QSelecting;	
}

void CCoolDrawDoc::OnUpdateQueue(CCmdUI* pCmdUI) 
{
  if(QSelecting)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);
}
bool CCoolDrawDoc::getQSelecting()
{
  return QSelecting;
}