// CoolDrawDoc.h : interface of the CCoolDrawDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_COOLDRAWDOC_H__F129E5EB_C670_11D6_A77A_D1F8C444EF4F__INCLUDED_)
#define AFX_COOLDRAWDOC_H__F129E5EB_C670_11D6_A77A_D1F8C444EF4F__INCLUDED_


#include "CoolDefs.h"
#include "CFigure.h"
#include "CText.h"

#include <afxtempl.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CCoolDrawDoc : public CDocument
{
protected: // create from serialization only
	CCoolDrawDoc();
	DECLARE_DYNCREATE(CCoolDrawDoc)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCoolDrawDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCoolDrawDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
  bool addFigure(CRect&);
  bool addSelected(CFigure*);
  void clearSelected();
  bool removeFigure(CFigure*);
  // the list of figures
  CTypedPtrList <CObList, CFigure*> figureStoreArr;
  // temp spot for selection.  Future way to send to back, etc.
  CList <CFigure*, CFigure*> selectedArr; 
  void setText(CString&);
  CString getText();
  shapeVal getShape();
  styleVal getStyle();
  COLORREF getColor();
  bool getErasing();
  bool getFilling();
  bool getQSelecting();
  bool showFloat;
  CRect getDocExtent();

protected:
  // draw with these
  styleVal lineStyle;
  shapeVal currentShape;
  COLORREF currentColor;
  CString currentText;

  // special behavior like erase and fill
  styleVal prevLStyle; // when a new shape or style is selected turn 
  shapeVal prevShape;  // off erasing or filling.
  shapeVal returnToShape; // if Text is cancelled, use this shape.
  bool erasing;
  bool filling;
  bool QSelecting;


// Generated message map functions
protected:
	//{{AFX_MSG(CCoolDrawDoc)
	afx_msg void OnViewAttributeLineNarrow();
	afx_msg void OnUpdateViewAttributeLineNarrow(CCmdUI* pCmdUI);
	afx_msg void OnViewAttributeLineMedium();
	afx_msg void OnUpdateViewAttributeLineMedium(CCmdUI* pCmdUI);
	afx_msg void OnViewAttributeLineThick();
	afx_msg void OnUpdateViewAttributeLineThick(CCmdUI* pCmdUI);
	afx_msg void OnViewAttributeLineFill();
	afx_msg void OnUpdateViewAttributeLineFill(CCmdUI* pCmdUI);
	afx_msg void OnShapeCircle();
	afx_msg void OnUpdateShapeCircle(CCmdUI* pCmdUI);
	afx_msg void OnShapeLine();
	afx_msg void OnUpdateShapeLine(CCmdUI* pCmdUI);
	afx_msg void OnShapeRectangle();
	afx_msg void OnUpdateShapeRectangle(CCmdUI* pCmdUI);
	afx_msg void OnShapeText();
	afx_msg void OnUpdateShapeText(CCmdUI* pCmdUI);
	afx_msg void OnViewAttributeColor();
	afx_msg void OnButton32782();
	afx_msg void OnButton32783();
	afx_msg void OnButton32784();
	afx_msg void OnButton32785();
	afx_msg void OnButton32786();
	afx_msg void OnButton32788();
	afx_msg void OnUpdateButton32786(CCmdUI* pCmdUI);
	afx_msg void OnUpdateButton32788(CCmdUI* pCmdUI);
	afx_msg void OnQueue();
	afx_msg void OnUpdateQueue(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_COOLDRAWDOC_H__F129E5EB_C670_11D6_A77A_D1F8C444EF4F__INCLUDED_)
