// CoolDrawView.cpp : implementation of the CCoolDrawView class
//

#include "stdafx.h"
#include "CoolDraw.h"

#include "ChildFrm.h"
#include "MainFrm.h"
#include "CoolDrawDoc.h"
#include "CoolDrawView.h"
#include <math.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoolDrawView

IMPLEMENT_DYNCREATE(CCoolDrawView, CScrollView)

BEGIN_MESSAGE_MAP(CCoolDrawView, CScrollView)
	//{{AFX_MSG_MAP(CCoolDrawView)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_COMMAND(ID_VIEW_FLOATINGBAR, OnViewFloatingbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_FLOATINGBAR, OnUpdateViewFloatingbar)
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoolDrawView construction/destruction

CCoolDrawView::CCoolDrawView()
{
  m_pnDotPen.CreatePen(PS_DOT, 1, RGB(0,0,0));
  m_bClickedIn = false;
  m_ptStartPoint = CPoint(0,0);
  m_ptPrevPoint = CPoint(0,0);
  m_pfigDragged = 0;
  m_ptLastDrag = CPoint(0,0);
  m_bDragging = false; // actually dragging
  m_bDragMode = false; // preparing to drag
  m_bShowFloat = true;
  m_bIsMod = false;
  m_bSelectEnable = false;
  m_pUpperLeft = CPoint(0,0);
}

CCoolDrawView::~CCoolDrawView()
{
}

BOOL CCoolDrawView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CCoolDrawView drawing

void CCoolDrawView::OnInitialUpdate()
{
	//CScrollView::OnInitialUpdate();

	CSize sizeTotal(1000, 2000);
  CSize page(650,250);
  CSize line(50,50);
  SetScrollSizes(MM_LOENGLISH, sizeTotal,page,line);
}

void CCoolDrawView::OnDraw(CDC* pDC)
{

	CCoolDrawDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

  CFigure* tempFig;
  POSITION aPosition = pDoc->figureStoreArr.GetHeadPosition();
  while(aPosition)
  {
    tempFig = pDoc->figureStoreArr.GetNext(aPosition);
    tempFig->draw(pDC);
  }
}


/////////////////////////////////////////////////////////////////////////////
// CCoolDrawView printing

BOOL CCoolDrawView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
//	BOOL retVal = DoPreparePrinting(pInfo);
  CCoolDrawDoc* theDoc = GetDocument();
  CRect docExt = theDoc->getDocExtent();
  double horzPages = ceil((docExt.right - docExt.left)/600.0);
  double vertPages = ceil((docExt.bottom - docExt.top)/900.0);

  //Make sure info is available later
  m_nHorzPages = (int) horzPages;
  m_nVertPages = (int) vertPages;
  m_pUpperLeft = CPoint(docExt.left, docExt.bottom);

  int pages = (int) (horzPages*vertPages + 1);
  pInfo->SetMaxPage(pages);
  pInfo->m_nNumPreviewPages = pages;
  return DoPreparePrinting(pInfo);
}

void CCoolDrawView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CCoolDrawView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CCoolDrawView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	//CScrollView::OnPrint(pDC, pInfo);
  CCoolDrawDoc* theDoc = GetDocument();
  CString docTitle = theDoc->GetTitle();
  if(pInfo->m_nCurPage == 1)
  {
    LOGFONT logFont;
    memset(&logFont, 0, sizeof(LOGFONT));
    logFont.lfHeight = 45;

    CFont font;
    CFont* pOld = NULL;
    if(font.CreateFontIndirect(&logFont))
      pOld = pDC->SelectObject(&font);

    pDC->SetTextAlign(TA_CENTER);
    pDC->TextOut(pInfo->m_rectDraw.right/2, pInfo->m_rectDraw.bottom/2, docTitle);

    if(pOld != NULL)
    {
      pDC->SelectObject(pOld);
    }
  }
  else
  {
    LOGFONT logFont;
    memset(&logFont, 0, sizeof(LOGFONT));
    logFont.lfHeight = 25;
    CFont font;
    CFont* pOld = NULL;
    if(font.CreateFontIndirect(&logFont))
      pOld = pDC->SelectObject(&font);

    pDC->SetTextAlign(TA_LEFT);
    CString pageHeader;
    pageHeader.Format("%s, Page %d",docTitle, pInfo->m_nCurPage);

    pDC->TextOut(5,-10, pageHeader);

    TEXTMETRIC textMetric;
    pDC->GetTextMetrics(&textMetric);

    int y = -20 - textMetric.tmHeight;
    pDC->MoveTo(0,y);
    pDC->LineTo(pInfo->m_rectDraw.right,y);
    if(pOld != NULL)
      pDC->SelectObject(pOld);
    int xPos = m_pUpperLeft.x + 600*((pInfo->m_nCurPage)%m_nHorzPages);
    int yPos = m_pUpperLeft.y - 900*((pInfo->m_nCurPage - 2)/m_nHorzPages);
    int xOffset = (pInfo->m_rectDraw.right - 600) / 2;
    int yOffset = - (pInfo->m_rectDraw.bottom + 900) /2;
    CPoint oldOrig = pDC->SetWindowOrg(xPos - xOffset, yPos + yOffset);
    pDC->IntersectClipRect(xPos, yPos, xPos + 600, yPos - 900);
    OnDraw(pDC);
    pDC->SelectClipRgn(NULL);
    pDC->SetWindowOrg(oldOrig);
  }
  return;
}
/////////////////////////////////////////////////////////////////////////////
// CCoolDrawView diagnostics

#ifdef _DEBUG
void CCoolDrawView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CCoolDrawView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CCoolDrawDoc* CCoolDrawView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCoolDrawDoc)));
	return (CCoolDrawDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCoolDrawView message handlers

void CCoolDrawView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CClientDC theDC(this);
  CCoolDrawDoc* theDoc = GetDocument();
  CFigure* tempFig;


  m_ptStartPoint = point;
  m_ptPrevPoint = point;

  m_bClickedIn = false;

  OnPrepareDC(&theDC);
  theDC.DPtoLP(&point);
  m_ptLastDrag = point;
//CString pointDesc;
//pointDesc.Format("At point (%d,%d)", point.x, point.y);
//AfxMessageBox(pointDesc, 0, 0);
  
  POSITION aPosition = theDoc->figureStoreArr.GetHeadPosition();
  theDoc->selectedArr.RemoveAll();
  if(theDoc->figureStoreArr.IsEmpty())
    aPosition = 0;
  while(aPosition)
  {
    tempFig = theDoc->figureStoreArr.GetNext(aPosition);
    if(tempFig->getOver(point))
    {
      theDoc->addSelected(tempFig);
//AfxMessageBox("got it: " , 0, 0);
    }
  }
  if(!theDoc->selectedArr.IsEmpty())
  {
    POSITION aPosition = theDoc->selectedArr.GetHeadPosition();
    tempFig = theDoc->selectedArr.GetAt(aPosition);
    CRect tempRect;
    tempRect = tempFig->getRect();
    if(theDoc->getErasing())
    {
      theDoc->removeFigure(tempFig);
      theDC.LPtoDP(tempRect);
      tempRect.NormalizeRect();
      InvalidateRect(tempRect);
    }
    else if(theDoc->getFilling())
    {
      if(tempFig->getShape() != LINE)
      {
        theDoc->SetModifiedFlag();
        tempFig->setStyle(FILL);
        theDC.LPtoDP(tempRect);
        tempRect.NormalizeRect();
        InvalidateRect(tempRect);
      }
    }
    else
    {
      m_bSelectEnable = true;
      m_pfigDragged = tempFig;
      theDC.SetROP2(R2_MASKPENNOT);
      m_pfigDragged->draw(&theDC, RGB(192,192,192));
      m_bDragMode = true;
      SetCapture();
    }
  }
  else //didn't select something
  {
    if(theDoc->getShape() == TEXT)
    {
      CFont tempFont;
      tempFont.CreatePointFont(240, FONT_NAME, &theDC);
      CFont* oldFont = theDC.SelectObject(&tempFont);
      CSize aSize = theDC.GetTextExtent(theDoc->getText());
      if(aSize.cy == 0)
        aSize.cy = 1;
      
      m_nTextRatio = ((double)aSize.cx)/((double)aSize.cy); 
    }


//      CTextDialog aTextDlg;
//      if(aTextDlg.DoModal() == IDOK)
//      {
//        theDoc->setText(aTextDlg.m_sDlgText);
//        CSize aSize = theDC.GetTextExtent(aTextDlg.m_sDlgText);
//        CRect aRect = CRect(point.x, point.y, point.x + aSize.cx , point.y - aSize.cy );
//        theDoc->addFigure(aRect);
//        theDC.LPtoDP(aRect);
//        aRect.NormalizeRect();
//        InvalidateRect(aRect);
//      }
//      return;
//    }
    m_bClickedIn = true;
    SetCapture();
  }
//	CView::OnLButtonDown(nFlags, point);
}

void CCoolDrawView::OnMouseMove(UINT nFlags, CPoint point) 
{
  //dragging activities
  if((nFlags | MK_LBUTTON) && m_bDragMode)
  {
    CClientDC theDC(this);
    theDC.LPtoDP(&m_ptStartPoint);
    CSize aSize = point - m_ptStartPoint;
    if(aSize.cx < 0)
      aSize.cx = -aSize.cx;
    if(aSize.cy < 0)
      aSize.cy = -aSize.cy;
    if(((aSize.cx + aSize.cy) < 15) && (!m_bDragging))
      return;
    else
    {
      m_bDragging = true;
      if(m_bSelectEnable)
        m_bSelectEnable = false;
      dragIt(point);
      return;
    }
  }

  //rubber banding activities
  if((nFlags | MK_LBUTTON) && m_bClickedIn)
  {
    CClientDC theDC(this);

    theDC.LPtoDP(&m_ptStartPoint);
    theDC.LPtoDP(&m_ptPrevPoint);

    CPen* tempPen = theDC.SelectObject(&m_pnDotPen);
    CBrush* tempBrush = static_cast<CBrush*> (theDC.SelectStockObject(NULL_BRUSH));
    theDC.SetROP2(R2_NOTXORPEN);
    CCoolDrawDoc* pDoc = GetDocument();
    switch(pDoc->getShape())
    {
    case CIRCLE:
      theDC.Ellipse(CRect(m_ptStartPoint, m_ptPrevPoint));
      theDC.Ellipse(CRect(m_ptStartPoint, point));
      theDC.DPtoLP(&point);
      theDC.DPtoLP(&m_ptStartPoint);
      m_ptPrevPoint = point;
      break;
    case LINE:
      theDC.MoveTo(m_ptStartPoint);
      theDC.LineTo(m_ptPrevPoint);
      theDC.MoveTo(m_ptStartPoint);
      theDC.LineTo(point);
      theDC.DPtoLP(&point);
      theDC.DPtoLP(&m_ptStartPoint);
      m_ptPrevPoint = point;
      break;
    case TEXT:
      {
        double negIt = 1.0;
        //double textRatio = AVG_LETTER_RATIO*((double)(pDoc->getText().GetLength()));
        CSize dist = point - m_ptStartPoint;
        CSize tempDist = point - m_ptStartPoint;
        CSize lastDist = m_ptPrevPoint - m_ptStartPoint;

        double currentRatio;
        if(tempDist.cy == 0)
          currentRatio = 9.9E20;
        else
          currentRatio = ((double)tempDist.cx)/((double)tempDist.cy);
        if(lastDist.cx < 0)
          lastDist.cx = -lastDist.cx;
        //The effective Ratio prevents trailing 'f's from being chopped off.
        double effectiveRatio = (m_nTextRatio + .1 +.0005*(lastDist.cx));
        if(currentRatio < 0)
        {
          negIt = -1.0;
          currentRatio = -currentRatio;
        }
        if(currentRatio > effectiveRatio)
        {
          dist.cx = (int) (negIt*( ((double)dist.cy) *(effectiveRatio)));
        }
        else if(currentRatio < effectiveRatio)
        {
          dist.cy = (int) (negIt*(((double)dist.cx)/(effectiveRatio)));
        }
        point = m_ptStartPoint + dist;

        theDC.Rectangle(CRect(m_ptStartPoint, m_ptPrevPoint));
        theDC.Rectangle(CRect(m_ptStartPoint, point));
        theDC.DPtoLP(&point);
        theDC.DPtoLP(&m_ptStartPoint);
        m_ptPrevPoint = point;
        break;
      }
    default:
      theDC.Rectangle(CRect(m_ptStartPoint, m_ptPrevPoint));
      theDC.Rectangle(CRect(m_ptStartPoint, point));
      theDC.DPtoLP(&point);
      theDC.DPtoLP(&m_ptStartPoint);
      m_ptPrevPoint = point;
    }
    theDC.SelectObject(tempPen);
    theDC.SelectObject(tempBrush);
    theDC.SetROP2(R2_COPYPEN);

    //	  CView::OnMouseMove(nFlags, point);
  }
}

void CCoolDrawView::OnLButtonUp(UINT nFlags, CPoint point) 
{
  if(this == GetCapture())
    ReleaseCapture();

  if((m_bClickedIn == false)&&(m_bDragMode == false))
    return;

  if(m_bDragMode)
  {
    dragIt(point);
    if(m_bIsMod)
    {
      CCoolDrawDoc* theDoc = GetDocument();
      theDoc->SetModifiedFlag();
    }
    Invalidate();
    m_bDragging = false;
    m_bDragMode = false;
    m_pfigDragged = 0;
    return;
  }

  CClientDC theDC(this);
  theDC.SetROP2(R2_NOTXORPEN);
  m_bClickedIn = false;

  //OnPrepareDC(&theDC);
  theDC.LPtoDP(&m_ptStartPoint);
  theDC.LPtoDP(&m_ptPrevPoint);
  //theDC.DPtoLP(&point);
  //theDC.LPtoDP(&point);
  ///theDC.DPtoLP(&point);
  //theDC.LPtoDP(&point);
  CRect tempRect = CRect(m_ptStartPoint, m_ptPrevPoint);
  
  CPen* tempPen = theDC.SelectObject(&m_pnDotPen);
  CBrush* tempBrush = static_cast<CBrush*> (theDC.SelectStockObject(NULL_BRUSH));

  CCoolDrawDoc* pDoc = GetDocument();
  switch(pDoc->getShape())
  {
  case CIRCLE:
    theDC.Ellipse(tempRect);
    break;
  case LINE:
    theDC.MoveTo(m_ptStartPoint);
    theDC.LineTo(m_ptPrevPoint);
    break;
  default:
    theDC.Rectangle(tempRect);
  }
  CRect eraseRect(m_ptStartPoint, point);
  fixRect(eraseRect, pDoc->getStyle());
  InvalidateRect(eraseRect, FALSE);
  //permRect.NormalizeRect();
  OnPrepareDC(&theDC);
  CRect permRect;
  if(pDoc->getShape() == TEXT)
    permRect = CRect(m_ptStartPoint, m_ptPrevPoint);
  else
    permRect = CRect(m_ptStartPoint, point);
  
  theDC.DPtoLP(permRect);
  //Ignoring infinitely small shapes
  if(!(m_ptStartPoint == point))
  {
    pDoc->addFigure(permRect);
  }
  theDC.SelectObject(tempPen);
  theDC.SelectObject(tempBrush);
  theDC.SetROP2(R2_COPYPEN);

	// TODO: Add your message handler code here and/or call default
	
	//CView::OnLButtonUp(nFlags, point);
}
void CCoolDrawView::dragIt(CPoint& point)
{
  CClientDC theDC(this);
  OnPrepareDC(&theDC);
  theDC.DPtoLP(&point);
  CSize Distance = point - m_ptLastDrag;
  //CSize 
  CRect tempRect;
  CRect tempPrevRect;
  m_ptLastDrag = point;

  //theDC.SetROP2(R2_COPYPEN);
  if(m_pfigDragged)
  {
    theDC.SetROP2(R2_NOTXORPEN);
    tempPrevRect = m_pfigDragged->getRect();
    m_pfigDragged->draw(&theDC);
    m_pfigDragged->move(Distance);
    m_pfigDragged->draw(&theDC);
    tempRect = m_pfigDragged->getRect();
  }
  
  theDC.LPtoDP(&tempRect);
  theDC.LPtoDP(&tempPrevRect);
  tempPrevRect.NormalizeRect();
  tempRect.NormalizeRect();
  if((Distance.cx != 0)||(Distance.cy != 0))
  {
    m_bIsMod = true;
  }
  tempPrevRect.UnionRect(tempPrevRect,tempRect);
  InvalidateRect(tempPrevRect);
  //InvalidateRect(tempRect, FALSE);
}
void CCoolDrawView::fixRect(CRect& fixer, styleVal howThick)
{
  int temp;
  temp = 0;
  if(fixer.right < fixer.left)
  {
    temp = fixer.right;
    fixer.right = fixer.left;
    fixer.left = temp;
  }
  if(fixer.bottom < fixer.top)
  {
    temp = fixer.bottom;
    fixer.bottom = fixer.top;
    fixer.top = temp;
  }
  fixer.top -= howThick/2 + 1;
  fixer.left -= howThick/2 + 1;
  fixer.bottom += howThick/2 + 1;
  fixer.right += howThick/2 + 1;
}

void CCoolDrawView::OnViewFloatingbar() 
{
  CChildFrame* theViewFrame = static_cast<CChildFrame*>(GetParentFrame());
  CMainFrame * theMainFrame = static_cast<CMainFrame*>(theViewFrame->GetParentFrame());
  //CCoolDrawDoc* theDoc = GetDocument();
  m_bShowFloat = !m_bShowFloat;

  theMainFrame->ShowControlBar(&(theMainFrame->m_myToolBar), m_bShowFloat, FALSE);
	theMainFrame->RecalcLayout();

//CString showIt;
//showIt.Format("called click %d",m_bShowFloat);	
//if(!m_bShowFloat);
//AfxMessageBox(showIt,0,0);
}

void CCoolDrawView::OnUpdateViewFloatingbar(CCmdUI* pCmdUI) 
{
  CCoolDrawDoc* theDoc = GetDocument();
  if(m_bShowFloat)
    pCmdUI->SetCheck();
  else
    pCmdUI->SetCheck(0);
  CString showIt;
  showIt.Format("called UI %d",m_bShowFloat);
  //AfxMessageBox(showIt,0,0);
}

void CCoolDrawView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
      
	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
 // CString yada;
 // yada.Format("the char: %c",nChar);
 // AfxMessageBox(yada,0,0);
  
  if(nChar == 'Q' || nChar == 'q')
  {
    CCoolDrawDoc* theDoc = GetDocument();
    if(m_pfigDragged)
    {
      CFigure* oldFig = m_pfigDragged;
      if(m_bSelectEnable &&(theDoc->getQSelecting()))
      {
        //AfxMessageBox("called",0,0);
        if(!(theDoc->selectedArr.IsEmpty()))
        {
          POSITION aPos = theDoc->selectedArr.Find(m_pfigDragged);
          m_pfigDragged = theDoc->selectedArr.GetNext(aPos);
          if(aPos)
            m_pfigDragged = theDoc->selectedArr.GetNext(aPos);
          else
          {
            aPos = theDoc->selectedArr.GetHeadPosition();
            m_pfigDragged = theDoc->selectedArr.GetAt(aPos);
          }
          CClientDC aDC(this);
          OnPrepareDC(&aDC);
          aDC.SetROP2(R2_COPYPEN);
          oldFig->draw(&aDC);
          aDC.SetROP2(R2_MASKPENNOT);
          m_pfigDragged->draw(&aDC, RGB(192,192,192));
        }
      }
    }
  }
}
//Leftovers:
//void CCoolDrawView::OnViewFloatingbar() 
  //CRect mainRect;
  //GetClientRect(&mainRect);
  //WINDOWPLACEMENT theLoc;
  //theLoc.length = sizeof(theLoc);
  //if(!theMainFrame->GetWindowPlacement(&theLoc))
  //  AfxMessageBox("lost",0,0);

 // theMainFrame->CalcWindowRect(
   // (&mainRect);
  //theMainFrame->ScreenToClient(mainRect);
  //CPoint aPoint(theLoc.rcNormalPosition.left + 215, theLoc.rcNormalPosition.top + 30);
  //mainRect.left = theLoc.rcNormalPosition.left ;
  //mainRect.top = theLoc.rcNormalPosition.top ;
  //mainRect.right = theLoc.rcNormalPosition.right ;
  //mainRect.bottom = theLoc.rcNormalPosition.bottom ;
  //CString locDesc;
  //locDesc.Format("Points at: min(%d,%d) max(%d,%d)", theLoc.rcNormalPosition.left, theLoc.rcNormalPosition.top, theLoc.rcNormalPosition.right, theLoc.rcNormalPosition.bottom);
   //   clickedIn = false;

  //AfxMessageBox(locDesc, 0,0);
//  theMainFrame->DockControlBar(&(theMainFrame->m_myToolBar),0, &(theLoc.rcNormalPosition));
//  theMainFrame->FloatControlBar(&(theMainFrame->m_myToolBar), aPoint);
  //

  //theMainFrame->DockControlBar(&(theMainFrame->m_myToolBar));
  //theMainFrame->DrawMenuBar();
  //theMainFrame->EnableWindow();
  //theMainFrame->m_myToolBar.DestroyWindow();	
//if(!m_bShowFloat)
//{
 // ShowControlBar(&m_wndPaletteBar, !bVisible, FALSE);
//	RecalcLayout();
  //theMainFrame->m_myToolBar.ShowWindow(SW_HIDE);
  //CToolBarCtrl theBar = static_cast<CToolBarCtrl>
  //(theMainFrame->m_myToolBar.GetToolBarCtrl()).ShowWindow(SW_HIDE);
  //theBar.ShowWindow(SW_HIDE);
  //theDoc->showFloat = false;
//}
//else
//{  theMainFrame->m_myToolBar.ShowWindow(SW_NORMAL);
  //theDoc->showFloat = true;
//}


//OnDraw(CDC* pDC)
  //Flicker and drawing test pattern
  //CPen aPen;
  //aPen.CreatePen(PS_SOLID, 1, RGB(255, 0, 0));
  //CPen* pOldPen = pDC->SelectObject(&aPen);
  //int topX, topY, botX, botY;
  //topX = topY = 100;
  //botX = botY = topX + 100;
  //CPoint a(0,0);
  //CPoint b(0,0);
  //for(int loc = 30; loc < 250; loc += 5)
  //{
  //  topX = topY = loc;
  //  botX = botY = topX + 100;
  //  a.x = topX;
  //  a.y = topY;
  //  b.x = botX;
  //  b.y = botY;
  //  CPoint c((a.x + b.x)/2, a.y);
  //  pDC->Arc(a.x,a.y,b.x,b.y,c.x,c.y,c.x,c.y);
  //}
 // int TLX = topLeft.x;
 // int TLY = topLeft.y;
 // int BRX = bottomRight.x;
 // int BRY = bottomRight.y;
//ellipse 'n' line test pattern
  //double radSq = 0;
  //CPoint topLeft(45,-50);
  //CPoint bottomRight(50,-125);
  //CPoint LtopLeft(50,-125);
  //CPoint LbottomRight(45,-50);

  //double xDist = (bottomRight.x - topLeft.x);
  //double yDist = (topLeft.y - bottomRight.y) ; 
  //double xCoef = 1.0/(pow((xDist/2.0), 2));
  //double yCoef = 1.0/(pow((yDist/2.0), 2));
  //double xCenter = topLeft.x + xDist/(2.0);
  //double yCenter = topLeft.y - yDist/(2.0);
  //CPoint drawIt(0,0);
  //CString ellipseDesc;
  //ellipseDesc.Format("Drawing h: %10.1f w: %10.1f cx: %10.1f cy: %10.1f coefX: %10.1f coefY: %10.1f ",
  //                            yDist,xDist,xCenter,yCenter,xCoef,yCoef);
  //AfxMessageBox(ellipseDesc, 0,0);
  //for(int x = topLeft.x - 20; x < bottomRight.x + 20; x++)
  //{
  //  for(int y = topLeft.y + 20; y > bottomRight.y - 20; y--)
  //  {
  //    if(1.1 >= (xCoef*(x - xCenter)*(x - xCenter) + yCoef*(y - yCenter)*(y - yCenter)))
  //    {
  //      drawIt.x = x;
  //      drawIt.y = y;
  //      pDC->SetPixel(drawIt, RGB(255,0,255));
  //    }
  //  }
  //}

  //need code for lines like y = 5
  //double slope = 1.0*(LbottomRight.y - LtopLeft.y)/(1.0*(LbottomRight.x - LtopLeft.x));
  //double offset = LtopLeft.y - slope*LtopLeft.x;
  //CString lineDesc;
  //lineDesc.Format("Drawing line with slope: %10.1f and offset %10.1f", slope, offset);
  //AfxMessageBox(lineDesc, 0,0);
  //for(x = topLeft.x - 20; x < bottomRight.x + 20; x++)
  //{
  //  for(int y = topLeft.y + 20; y > bottomRight.y - 20; y--)
  //  {
  //    if((y + 0.0 >= slope*(x + 2.0) + offset)&&(y - 0.0 <= slope*(x - 2.0) + offset)&&(x + 3 > topLeft.x)&&(x - 3 < bottomRight.x)&&(y - 3 < topLeft.y)&&(y + 3 > bottomRight.y))
  //    {
  //      drawIt.x = x;
  //      drawIt.y = y;
  //      pDC->SetPixel(drawIt, RGB(255,0,0));
  //    }
  //  }
  //}

//void CCoolDrawView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
//{
//  int nDelta;
//  switch(nSBCode)
//  {
//  case SB_LINEDOWN:
//    nDelta = 50;
//    break;
//  case SB_PAGEDOWN:
//    nDelta = 100;
//    break;
//  case SB_LINEUP:
//    if(m_nHScrollPos > 50)
//      nDelta = -50;
//    else
//      nDelta = -m_nHScrollPos;
//    break;
//  case SB_PAGEUP:
//     if(m_nHScrollPos > 100)
//      nDelta = -100;
//    else
//      nDelta = -m_nHScrollPos;
//    break;
//  case SB_THUMBPOSITION:
//    nDelta = 5;
//    break;
//  default:
//    return;
//  }
// m_nHScrollPos =+ nDelta;
//  SetScrollPos(SB_HORZ, m_nHScrollPos);
//  //SetScrollPos(SB_VERT, m_nHScrollPos);
//  ScrollWindow(-nDelta, 0);
////	CScrollView::OnHScroll(nSBCode, nPos, pScrollBar);
//}

//OnDraw
//#if defined _DEBUG
//int i = 0;
//#endif

//#if defined _DEBUG
//if(i == 0)
//{
//  i = 1;
//  CString aMessage;
//  aMessage.Format("Shape: %d", tempFig->getShape());
//  AfxMessageBox(aMessage,0,MB_OK);
//}
//#endif




