// CoolDrawView.h : interface of the CCoolDrawView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_COOLDRAWVIEW_H__F129E5ED_C670_11D6_A77A_D1F8C444EF4F__INCLUDED_)
#define AFX_COOLDRAWVIEW_H__F129E5ED_C670_11D6_A77A_D1F8C444EF4F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CCoolDrawView : public CScrollView
{
protected: // create from serialization only
	CCoolDrawView();
	DECLARE_DYNCREATE(CCoolDrawView)

// Attributes
public:
	CCoolDrawDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCoolDrawView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCoolDrawView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
  CPoint m_ptStartPoint;
  CPoint m_ptPrevPoint;
  bool m_bClickedIn;
  CPen m_pnDotPen;
//  int m_nHScrollPos;
//  int m_nVScrollPos;
  CFigure* m_pfigDragged;
  CPoint m_ptLastDrag;
  bool m_bDragging; // is it actually dragging;
  bool m_bShowFloat;
  bool m_bIsMod;
  bool m_bSelectEnable;
  bool m_bDragMode; // is it getting ready to drag;
  int m_nHorzPages;
  int m_nVertPages;
  void dragIt(CPoint&);
  void fixRect(CRect&, styleVal);
  CPoint m_pUpperLeft;
  double m_nTextRatio;
  //POSITION selectedPos; // check for 

// Generated message map functions
protected:
	//{{AFX_MSG(CCoolDrawView)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnViewFloatingbar();
	afx_msg void OnUpdateViewFloatingbar(CCmdUI* pCmdUI);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in CoolDrawView.cpp
inline CCoolDrawDoc* CCoolDrawView::GetDocument()
   { return (CCoolDrawDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_COOLDRAWVIEW_H__F129E5ED_C670_11D6_A77A_D1F8C444EF4F__INCLUDED_)
