#include "survey.h"
#include <fstream>
#ifndef _survey_custsat_cpp
#define _survey_custsat_cpp
using namespace std;

survey::survey (int ID)
{
  this->ID = ID;
  numQuestions = 0;
  numResults = 0;
  results = new int[20];
  for (int i = 0; i < 20; i++)
    results[i] = -999;
}

int survey::getNumQuestions ()
{
  return numQuestions;
}

void survey::setName (char newName[128])
{
  strcpy (name, newName);
}

char *survey::getName ()
{
  return name;
}

int survey::getID ()
{
  return ID;
}

void survey::addQuestion (const char *newQuestion)
{
  numQuestions++;
  questions[numQuestions - 1] = new char[strlen (newQuestion) + 1];
  strcpy (questions[numQuestions - 1], newQuestion);
}

char *survey::getQuestion (int questionNum)
{
  if (questionNum < numQuestions)
    return questions[questionNum];
  else
    return "";
}

void survey::newResultSet ()
{
  numResults++;
  resultList.push_back (results);
  results = new int[20];
  for (int i = 0; i < 20; i++)
    results[i] = -999;
}

void survey::writeResults (ofstream & fout)
{
  fout << ":" << name << ":" << ID << ":" << numResults << ":" << endl;
  list < int *>::iterator iter;
  for (iter = resultList.begin (); iter != resultList.end (); iter++)
    {
      for (int i = 0; i < numQuestions; i++)
	{
	  fout << (*iter)[i] << " ";
	}
      fout << endl;
    }
}

survey::~survey ()
{
  for (int i = 0; i < numQuestions; i++)
    delete[]questions[i];
  list < int *>::iterator iter;
  for (iter = resultList.begin (); iter != resultList.end (); iter++)
    {
      delete[](*iter);
    }
}

//Here the results are output to the screen.
void survey::showStatistics ()
{
  //double mean[numQuestions];
  //double stdDev[numQuestions];
  //int N[numQuestions];
  double *mean = new double[numQuestions];
  double *stdDev = new double[numQuestions];
  int *N = new int[numQuestions];
  for (int l = 0; l < numQuestions; l++)
    {
      mean[l] = N[l] = 0;
    }
  list < int *>::iterator iter;
  int resultNum = 0;
  for (iter = resultList.begin (); iter != resultList.end (); iter++)
    {
      resultNum++;
      for (int i = 0; i < numQuestions; i++)
	{
	  if ((*iter)[i] > 0 && (*iter)[i] < 20)
	    {
	      N[i]++;
	      if (mean[i] != 0)
		mean[i] =
		  (mean[i] * (resultNum - 1) + static_cast <
		   double >((*iter)[i])) /(resultNum);
	      else
		mean[i] = static_cast < double >((*iter)[i]) / (resultNum);
	    }
	}
    }
  resultNum = 0;
  double stdDevTemp;
  for (int i = 0; i < numQuestions; i++)
    {
      stdDevTemp = 0;
      for (iter = resultList.begin (); iter != resultList.end (); iter++)
	{
	  if ((*iter)[i] > 0 && (*iter)[i] < 20)
	    {
	      stdDevTemp += ((*iter)[i] - mean[i]) * ((*iter)[i] - mean[i]);
	    }
	}
      stdDev[i] = sqrt (stdDevTemp);
    }
  cout << "Question\t\t\tObs.\tMean\t\tStd. Dev." << endl;
  for (int i = 0; i < numQuestions; i++)
    {
      cout << questions[i] << ":";
      //tabs look like they are 7 characters long.  Lining up data.
      for (int j = 0; j < (4 - strlen (questions[i]) / 7); j++)
	cout << "\t";
      cout << N[i] << "\t" << mean[i] << "\t\t" << stdDev[i] << endl;
    }
  delete[]mean;
  delete[]stdDev;
  delete[]N;
}

//Results to the screen
void survey::showForeignStatistics (list < int *>&results, int numQuestions)
{
  // double mean[numQuestions];
  // double stdDev[numQuestions];
  // int N[numQuestions];
  double *mean = new double[numQuestions];
  double *stdDev = new double[numQuestions];
  int *N = new int[numQuestions];
  for (int l = 0; l < numQuestions; l++)
    {
      mean[l] = N[l] = 0;
    }
  list < int *>::iterator iter;
  int resultNum = 0;
  for (iter = results.begin (); iter != results.end (); iter++)
    {
      resultNum++;
      for (int i = 0; i < numQuestions; i++)
	{
	  if ((*iter)[i] > 0 && (*iter)[i] < 20)
	    {
	      N[i]++;
	      if (mean[i] != 0)
		mean[i] =
		  (mean[i] * (resultNum - 1) + static_cast <
		   double >((*iter)[i])) /(resultNum);
	      else
		mean[i] = static_cast < double >((*iter)[i]) / (resultNum);
	    }
	}
    }
  resultNum = 0;
  double stdDevTemp;
  for (int i = 0; i < numQuestions; i++)
    {
      stdDevTemp = 0;
      for (iter = results.begin (); iter != results.end (); iter++)
	{
	  if ((*iter)[i] > 0 && (*iter)[i] < 20)
	    {
	      stdDevTemp += ((*iter)[i] - mean[i]) * ((*iter)[i] - mean[i]);
	    }
	}
      stdDev[i] = sqrt (stdDevTemp);
    }
  cout << "Question\t\t\tObs.\tMean\t\tStd. Dev." << endl;
  for (int i = 0; i < numQuestions; i++)
    {
      cout << questions[i] << ":";
      //tabs look like they are 7 characters long.  Lining up data.
      for (int j = 0; j < (4 - strlen (questions[i]) / 7); j++)
	cout << "\t";
      cout << N[i] << "\t" << mean[i] << "\t\t" << stdDev[i] << endl;
    }
  delete[]mean;
  delete[]stdDev;
  delete[]N;
}

void survey::exportData (list < int *>&outsideResults)
{
  list < int *>tempResults;
  int *results;
  list < int *>::iterator iter = this->resultList.begin ();
  while (iter != this->resultList.end ())
    {
      results = new int[20];
      for (int i = 0; i < numQuestions; i++)
	{
	  results[i] = (*iter)[i];
	}
      tempResults.push_back (results);
      iter++;
    }
  outsideResults.merge (tempResults);
}

void survey::writeWebResults (ofstream & fout)
{
  fout << "<b><font size=\"5\">" << name;
  fout << "</font></b> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; ID: " << ID;
  fout << "                <br>\
                <br>\
                <table width=\"60%\">\
                        <tr>\
                                <td width=\"40%\">\
                                        Question\
                                </td>\
                                <td>\
                                        Obs.\
                                </td>\
                                <td>\
                                        Results\
                                </td>\
                        <tr>" << endl;

  double *mean = new double[numQuestions];
  //double mean[numQuestions];
  double *stdDev = new double[numQuestions];
  //double stdDev[numQuestions];
  int *N = new int[numQuestions];
  //int N[numQuestions];
  for (int l = 0; l < numQuestions; l++)
    {
      mean[l] = N[l] = 0;
    }
  list < int *>::iterator iter;
  int resultNum = 0;
  for (iter = resultList.begin (); iter != resultList.end (); iter++)
    {
      resultNum++;
      for (int i = 0; i < numQuestions; i++)
	{
	  if ((*iter)[i] > 0 && (*iter)[i] < 20)
	    {
	      N[i]++;
	      if (mean[i] != 0)
		mean[i] =
		  (mean[i] * (resultNum - 1) + static_cast <
		   double >((*iter)[i])) /(resultNum);
	      else
		mean[i] = static_cast < double >((*iter)[i]) / (resultNum);
	    }
	}
    }
  resultNum = 0;
  double stdDevTemp;
  for (int i = 0; i < numQuestions; i++)
    {
      stdDevTemp = 0;
      for (iter = resultList.begin (); iter != resultList.end (); iter++)
	{
	  if ((*iter)[i] > 0 && (*iter)[i] < 20)
	    {
	      stdDevTemp += ((*iter)[i] - mean[i]) * ((*iter)[i] - mean[i]);
	    }
	}
      stdDev[i] = sqrt (stdDevTemp);
    }
  for (int i = 0; i < numQuestions; i++)
    {
      fout << "<td width=\"40%\">" << endl;
      fout << questions[i] << "</td><td>";
      fout << N[i] << "</td><td> <table cellpadding=\"0\"\
	 cellspacing=\"0\" border=\"0\">\
                                                <tr>" << endl;
      int numBars = (int) mean[i];
      int width =
	static_cast < int >(25 * (mean[i] - static_cast < double >(numBars)));
      if (width != 0)
	{
	  numBars++;
	}
      for (int j = 0; j < numBars; j++)
	{
	  fout <<
	    "<td><img border=\"0\" src=\"../images/redbar.gif\" width=\"";
	  if (j < numBars - 1 || width == 0)
	    fout << 25;
	  else
	    fout << width;
	  fout << "\" height=\"19\" align=\"absMiddle\" alt=\"Mean = " <<
	    mean[i];
	  fout << ", Std. Dev. = " << stdDev[i];
	  fout << "\"></td>" << endl;
	}
      fout << "</tr>\
                                        </table>\
                                </td>\
                        </tr>" << endl;
    }
  fout << "</table>\
		<br>\
 		<hr>\
 		<br>" << endl;
  fout.flush ();
  delete[]mean;
  delete[]stdDev;
  delete[]N;
}


#endif
