/*************************************************
 *custsat.cpp 23-Jan-2004 (c) 2004 Joe Bradshaw joe_bradshaw2000@hotmail.com
 *Reads surveys from a file, generates statistics and stores results.  
 *Multiple surveys are allowed.  Surveys may have the same name but must have
 *different IDs.  Some garbage is allowed to be around survey responses.  A 
 *web page with the results is generated in the public_html subfolder.  
 *Files:
 * survey.txt			default input survey file
 * .config.custsat		configuration file with information on what the
 * 				surveys look like.  Surveys have names, IDs and
 *				questions. 
 * .data.custsat		survey results with question responses in the 
 *				order of the questions asked.
 * public_html/results.html	web page with graphical results.
 * images/redbar.gif		graphic used for bar graph in results.html
 *
 *The idea is to have an email account where responses to several surveys are 
 *sent.  Appropriate shell scripts are written to get email from the account.
 *This program will then capture and store the results.  The email responses
 *from the users may have underscores or emoticons around the numerical results
 *but this program should be smart enough to sort it out, even if the response 
 *isn't on the same line as the question.  Email me and I'll help you set it up.
 *************************************************/


//#include <stdio.h>
//#include <stdio>
#include <iostream>
#include <fstream>
#include <list>
#include "survey.cpp"
using namespace std;

int findLastNum (char[]);
int lineCheck (char[], char[]);	//Return the last number in line if buf is found
bool isNum (char *);		//You're sure there's no text in that number!
void processArgs (int, char *[], char *&, bool &, char *&, int &, char *&,
		  char *&);
void setSurveys (list < survey * >&);	//get survey info from config file.
void writeSurveys (list < survey * >&);	//write surveys to disk and web page
void readSurveys (list < survey * >&);	//read surveys from disk
bool surveyComp (survey *, survey *);	//compare surveys by name

int main (int argc, char *argv[])
{
  if (strcmp (argv[argc - 1], "-?") == 0 || argc > 9)
    {
      cout <<
	"Usage: custsat [-f <surveyFile>] [-s [<surveyName>|<surveyID>]] [-b <surveyBeginString>] [-e <surveyEndString>]"
	<< endl;
      return -9;
    }
  char *surveyFile = "survey.txt";
  bool needStats = false;
  char *surveyStatName = NULL;
  int surveyStatID = 0;
  char *beginning = "---===# Survey";
  char *end = "---===# End";
  processArgs (argc, argv, surveyFile, needStats, surveyStatName,
	       surveyStatID, beginning, end);
  list < survey * >surveyList;
  list < survey * >::iterator iter;
  setSurveys (surveyList);	//Read from config.custsat for survey names and questions
  survey *currentSurvey;
  char aLine[8192];		//Larger lines send the program into an infinite loop
  bool inSurvey = false;
  bool inComment = false;
  //Reading from the file with the new surveys in it.
  ifstream fin;
  cout << "opening: " << surveyFile << endl;
  fin.open (surveyFile, ios_base::in);
  if (fin.good ())
    {
      cout << "File is good." << endl;
      fin.getline (aLine, 8190);
      while (!fin.eof ())
	{
//iter = surveyList.begin();    
	  for (iter = surveyList.begin (); iter != surveyList.end (); iter++)
	    {
//cout << "search for: " << beginning << "  " << (*iter)->getID() << endl;
	      if ((*iter)->getID () == lineCheck (aLine, beginning))
		{
		  inSurvey = true;
		  inComment = false;
		  cout << "In survey" << endl;
		  currentSurvey = (*iter);
		  break;
		}
	      if ((*iter)->getID () == lineCheck (aLine, end))
		{
		  inSurvey = false;
		  inComment = false;
		  cout << "Out of survey and comment" << endl;
		  currentSurvey->newResultSet ();
		  currentSurvey = NULL;
		  break;
		}
	    }
	  if (inSurvey)
	    {
	      int lastNum = findLastNum (aLine);
//cout << " gettin answers" << endl;
	      //Results all start at -999.  It is assumed that your customer
	      //service or product is never so bad that it deserves a -999
	      //(It's also assumed you never get a 100 either -- this is for
	      //qualitative responses).  If the question is found then give it
	      //a response value or -99.  Keep looking for a response until
	      //the next question is found.
	      for (int i = 0; i < currentSurvey->getNumQuestions (); i++)
		{
		  if (currentSurvey->results[i] < -99)
		    currentSurvey->results[i] =
		      lineCheck (aLine, currentSurvey->getQuestion (i));
		  if (currentSurvey->results[i] == -99 &&
		      currentSurvey->results[i + 1] == -999 && lastNum > -99)
		    currentSurvey->results[i] = lastNum;
//cout << "Checked: " << currentSurvey->getQuestion(i) << endl;
		}
	    }
	  try
	  {
	    //Read more data
	    fin.getline (aLine, 8190);
	  }
	  catch (exception e)
	  {
	    cout << e.what () << endl;
	  }
	}
    }
  cout << "Analyzed file" << endl;
  readSurveys (surveyList);	//Surveys saved to disk are added to the fresh batch
  //Here the surveys are being grouped by name.  Surveys may have the same name
  //but different IDs so the all the surveys with the same name have to be 
  //combined together for statistics calculation.  I'm not sure if this really 
  //works.
  if (needStats && surveyStatName != NULL && surveyStatID == 0)
    {
      cout << "go by name" << surveyStatName << ":" << endl;
      list < int *>statList;
      int numQuestions = 99;
      survey *tempSurvey = NULL;
      for (iter = surveyList.begin (); iter != surveyList.end (); iter++)
	{
	  if (strcmp ((*iter)->getName (), surveyStatName) == 0)
	    {
	      if ((*iter)->getNumQuestions () < numQuestions)
		numQuestions = (*iter)->getNumQuestions ();
	      (*iter)->exportData (statList);
	      if (tempSurvey == NULL)
		{
		  tempSurvey = new survey ((*iter)->getID ());
		  tempSurvey->setName ((*iter)->getName ());
		  for (int i = 0; i < (*iter)->getNumQuestions (); i++)
		    {
		      tempSurvey->addQuestion ((*iter)->getQuestion (i));
		    }
		}
	    }
	}
      //Memory may be leaking here.  That clear() method below is supposed to
      //free up the memory.  The survey with the least questions is used to 
      //determine how many questions there are.  The text for the questions is 
      //gathered from the first survey with the correct name.  The wiseacre
      //who puts different questions for surveys with the same names will get 
      //what's coming to him and then some.
      if (numQuestions < 99)
	tempSurvey->showForeignStatistics (statList, numQuestions);
      statList.clear ();
    }
  //No combining needed since this survey will have a unique ID
  else if (needStats && surveyStatName == NULL && surveyStatID != 0)
    {
      cout << "go by ID" << surveyStatID << endl;
      for (iter = surveyList.begin (); iter != surveyList.end (); iter++)
	{
	  if ((*iter)->getID () == surveyStatID)
	    {
	      (*iter)->showStatistics ();
	    }
	}
    }
  //Otherwise just do stats for all surveys by ID.
  else
    {
      cout << "doing all stats" << endl;
      surveyList.sort (surveyComp);
      for (iter = surveyList.begin (); iter != surveyList.end (); iter++)
	{
	  cout << (*iter)->getName ();
	  //Trying to make ID always be in the same column
	  for (int i = 0; i < 6 - strlen ((*iter)->getName ()) / 7; i++)
	    cout << "\t";
	  cout << "ID: " << (*iter)->getID () << endl;
	  (*iter)->showStatistics ();
	  cout << endl;
	}
    }
  writeSurveys (surveyList);	//Save all the surveys to disk and web page
  fin.close ();
  return 3451;
}

//Nothing special here, probably there is a better way to do this but this
//seemed easiest at the time.  Just testing for a number.
bool isNum (char *testNum)
{
  char nums[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };
  int numLen = strlen (testNum);
  if (numLen == 0)
    return false;
  bool inNum = false;
  for (int i = 0; i < numLen; i++)
    {
      for (int j = 0; j < 10; j++)
	{
	  if (testNum[i] == nums[j])
	    {
	      inNum = true;
	      break;
	    }
	}
      if (!inNum)
	return false;
      inNum = false;
    }
  return true;
}

// This method finds the last number in the line
// When no number is found, -99 is returned.
int findLastNum (char aLine[500])
{
  int NUM_SIZE = 16;
  char *foundNum = new char[NUM_SIZE];
  int numLen = 0;
  bool foundIt = false;
  bool inNum;
  char nums[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };
  int lineLen = strlen (aLine);
  for (int i = lineLen - 1; i >= 0; i--)
    {
      inNum = false;
      for (int j = 0; j < 10; j++)
	{
	  if (nums[j] == aLine[i])
	    {
	      inNum = true;
#ifdef _DEBUG_
	      cout << aLine[i] << endl;
#endif
	    }
	}
      if (inNum == true && foundIt == false)
	{
	  numLen++;
	  if (numLen > NUM_SIZE - 2)
	    numLen = NUM_SIZE - 2;
	}
      if (inNum == false && numLen != 0)
	{
	  foundIt = true;
	  int k;
	  for (k = 0; k < numLen; k++)
	    {
	      foundNum[k] = aLine[i + k + 1];
	    }
	  foundNum[k + 1] = '\0';
	  break;
	}
    }
#ifdef _DEBUG_
  if (foundIt)
    {
      for (int i = 0; i < 15; i++)
	{
	  if (foundNum[i] == '\0')
	    break;
	  cout << foundNum[i];
	}
      cout << "*";
    }
#endif
  int tempInt = atoi (foundNum);
  if (foundIt)
    {
      return tempInt;
    }
  else
    return -99;
  delete[]foundNum;

}

// This method returns the last number in aLine if aBuf is found.  If aBuf is 
// not found, -999 is returned.  If no number is found, -99 is returned.
int lineCheck (char aLine[500], char aBuf[500])
{
  int i, j = i = 0;
  int lineLen = strlen (aLine);
  int bufLen = strlen (aBuf);
  if (bufLen == 0 || lineLen == 0)
    return -999;
  for (i = 0; i < lineLen; i++)
    {
      if (aLine[i] == aBuf[0] && i + bufLen < lineLen)
	{
	  for (j = 0; j < bufLen; j++)
	    {
	      if (aLine[i + j] != aBuf[j])
		break;
	      if (j == (bufLen - 1) && aLine[i + j] == aBuf[j])
		return findLastNum (aLine);
	    }
	}
    }
  return -999;
}

//read from a configuration file to determine what the survey looks like.
//surveys have no more than 20 questions.  Surveys may have the same name
//but different IDs so that performance can be secretly monitored.  
void setSurveys (list < survey * >&surveyList)
{
  ifstream fin;
  fin.open (".config.custsat", ios::in);
  if (!fin.good ())
    return;
  char buf[501];
  while (!fin.eof ())
    {
      fin.getline (buf, 500, ':');
      if (!isNum (buf))
	{
	  return;
	}
      cout << "ID: " << buf << endl;
      survey *pSurvey = new survey (atoi (buf));
      fin.getline (buf, 500, ':');
//cout << "Name: " << buf << endl;
      pSurvey->setName (buf);
      fin.getline (buf, 500, ':');
//cout << "#: " << buf << endl;
      int numQs = atoi (buf);
      fin.getline (buf, 500);	//this line is blank
      for (int i = 0; i < numQs; i++)
	{
	  fin.getline (buf, 500);
//cout << "Q" << i << ": " << buf << endl;
	  pSurvey->addQuestion (buf);
	}
      if (!(strlen (pSurvey->getName ()) == 0) && !(pSurvey->getID () == 0))
	surveyList.push_back (pSurvey);
    }
  fin.close ();
}

// Survey results are kept in the .data.custsat file and also written
// in html to a file in a public_html directory
void writeSurveys (list < survey * >&surveyList)
{
  ofstream fout;
  fout.open (".data.custsat", ios::out | ios::trunc);
  list < survey * >::iterator iter;
  for (iter = surveyList.begin (); iter != surveyList.end (); iter++)
    {
      (*iter)->writeResults (fout);
//delete (*iter);
    }

  fout.flush ();
  fout.close ();

  ofstream wout;
  wout.open ("public_html/results.html", ios::out | ios::trunc);
  wout << "<html>\
        <head>\
                <title>Survey Results</title>\
        </head>\
        <body bgcolor=\"#ffffff\">" << endl;

  for (iter = surveyList.begin (); iter != surveyList.end (); iter++)
    {
      (*iter)->writeWebResults (wout);
      delete (*iter);
    }
  wout << "               <a href=\".out.file\" type=\"text\">See all data</a>\
        </body>\
</html>" <<
    endl;

  wout.flush ();
  wout.close ();
}

//read in surveys from data file
void readSurveys (list < survey * >&surveyList)
{
  ifstream fin;
  fin.open (".data.custsat", ios::in);
  if (!fin.good ())
    return;
  char buf[501];
  list < survey * >::iterator iter;
  while (!fin.eof ())
    {
      fin.getline (buf, 500, ':');
//cout << buf << endl;
      for (iter = surveyList.begin (); iter != surveyList.end (); iter++)
	{
//int i = 0;
//cout << i << endl;
	  if (strcmp (buf, (*iter)->getName ()) == 0)
	    {
	      fin.getline (buf, 500, ':');
	      while (atoi (buf) != (*iter)->getID ())
		{
		  iter++;
		  if (iter == surveyList.end ())
		    {
		      iter--;	//Would the loop increment iter even if it's at the end -- I think so.
		      break;
		    }
		}
	      if (atoi (buf) == (*iter)->getID ())
		{
		  fin.getline (buf, 500, ':');	//this line's blank
		  int numRecs = atoi (buf);
		  cout << "getting " << numRecs << " recs." << endl;
		  for (int i = 0; i < numRecs; i++)
		    {
		      for (int j = 0; j < (*iter)->getNumQuestions (); j++)
			{
			  fin >> (*iter)->results[j];
//fin >> buf;
//cout << buf << endl;
			}
		      (*iter)->newResultSet ();
		    }
		}
	    }
//cout << "finished one" << endl;
	}
    }
  cout << "done" << endl;
}

//void processArgs(int, char*[], char*, bool&, char*, int&, char*, char*);
void processArgs (int argc, char *argv[], char *&surveyFile, bool & needStats,
		  char *&surveyStatName, int &surveyStatID, char *&beginning,
		  char *&end)
{
  for (int i = 0; i < argc; i++)
    {
//cout << "checking: " << argv[i] << "<-" << endl;
      if (strcmp (argv[i], "-f") == 0)
	{
//cout << "found -f" << endl;
//cout << "argc = " << argc << ", i + 1 = " << i + 1 << ":"<< strcmp(argv[i + 1], "-s") << endl;
	  //check for skipped filename argument
	  if (argc > i + 1 && strcmp (argv[i + 1], "-s") != 0)
	    {
	      surveyFile = argv[i + 1];
	      cout << "Survey file is: " << surveyFile << endl;
	    }
	}
      if (strcmp (argv[i], "-s") == 0)	//Statistics
	{
	  if (argc > i + 1 && strcmp (argv[i + 1], "-b") != 0)
	    {
	      if (isNum (argv[i + 1]))
		surveyStatID = atoi (argv[i + 1]);
	      else
		surveyStatName = argv[i + 1];
	    }
	  needStats = true;
	}
      if (strcmp (argv[i], "-b") == 0)	//beginning of survey delimiter
	{
	  if (argc > i + 1 && strcmp (argv[i + 1], "-e") != 0)
	    beginning = argv[i + 1];
	}
      if (strcmp (argv[i], "-e") == 0)	//end of survey delimiter
	{
	  if (argc > i + 1)
	    end = argv[i + 1];
	}
    }
}

bool surveyComp (survey * first, survey * second)
{
  return strcmp (first->getName (), second->getName ()) <= 0;
}

	//cout << "Rating for question #1: " << (*iter)->results[0] << endl;
	//cout << "Rating for question #2: " << (*iter)->results[1] << endl;
	//cout << "Rating for question #3: " << (*iter)->results[2] << endl;
	//iter++;
	//cout << "Rating for question #1: " << (*iter)->results[0] << endl;
	//cout << "Rating for question #2: " << (*iter)->results[1] << endl;
	//cout << "Rating for question #3: " << (*iter)->results[2] << endl;
//cout << lastNum << "#";
//cout << "numQ: " << aSurvey.getNumQuestions() << endl;
//cout << "Q1: " << aSurvey.getQuestion(0) << endl;
//cout << "results: " << aSurvey.results[0] << endl;
//      for(int i = 0;i < 10;i++)
//      {
//              //printf("%d\n", i);
//              cout << "yada";
//      }
//      pSurvey = new survey(54332);
//      pSurvey->setName("Satisfaction Survey 10/03");
//      pSurvey->addQuestion("Promptness");
//      pSurvey->addQuestion("Friendliness");
//      pSurvey->addQuestion("Speed");
//      pSurvey->addQuestion("Quality");
//      pSurvey->addQuestion("Communication");
//      pSurvey->addQuestion("Overall");
//      surveyList.push_back(pSurvey);
