import java.awt.*;
import java.util.*;
import javax.swing.*;

public class PCanvas extends JPanel
{
	public static int WIDTH = 400; //Dimensions of play area
	public static int HEIGHT = 300;
	private static int lpadx = 20; //Left Paddle X Value Left Edge
	private int lpady = 115;
	private static int rpadx = 370; //Right Paddle x Value Left Edge
	private int rpady = 115;
	public static int padt = 5; //Default thickness
	private static int padw = 50; //Value to add or subtract to get
					      //bottom or top of paddle
	private int rpadVel = 0;
	private int lpadVel = 0;
	private int lScore = 0;
	private int rScore = 0;
	private int lastRScore = 0;
	private int lastLScore = 0;
	private boolean padDown = false;
	private boolean padUp = false;
	public boolean lpadDown = false;
	public boolean lpadUp = false;

	private int ticksSince = 0;
	private int sinceStruck = 0;
	private boolean lStruck = false;
	private boolean rStruck = false;
	private Ball theBall;
	private Painter p;
	private PServer pNet = null;
	//Ticker t; 

	public PCanvas(String _ipAddr)
	{
		super();
		if(_ipAddr.toLowerCase().equals("server"))
		{
			System.out.println("It's a server");
			pNet = new PServer(this);
		}
		else if(_ipAddr.equals("..."))
		{
			System.out.println("Single Machine Mode: A Z vs upArrow downArrow");
		}
		else
		{
			System.out.println(_ipAddr);
		}
		theBall = new Ball();
		theBall.setXY(WIDTH/2, HEIGHT/2);
		theBall.xVel = ((new Random()).nextInt(6) - 3)*2; 
		theBall.yVel = ((new Random()).nextInt(6) - 3)*2;
		if(theBall.xVel == 0)
			theBall.xVel = 3;
		if(theBall.yVel == 0)
			theBall.yVel = -7;
		Painter p = new Painter(this);
	//	Ticker t = new Ticker(this);F:\pong\pong
	}

	public void paintComponent(Graphics g)
	{
		//Color oldColor = g.getColor();
		g.setColor(Color.white);
		g.fillRect(0,0,WIDTH,HEIGHT);
		theBall.draw(g);

		//g.setColor(Color.black);		
		//g.drawRect(lpadx - 1,lpady - 1,padt + 1,padw + 1);
		//g.drawRect(rpadx - 1,rpady - 1,padt + 1,padw + 1);

		g.setColor(Color.red);
		g.setFont(new Font("SanSerif", Font.BOLD, 12));
		g.drawString(lScore + " ", WIDTH/3, 30);
		g.drawString(rScore + " ", 2*WIDTH/3, 30);
		
		for(int i = lpadx; i < lpadx + padt; i++)
		{
			int finaly = lpady + padw;
			g.drawLine(i,lpady,i,finaly);
		}
		for(int j = rpadx; j < rpadx + padt; j++)
		{
			int finaly = rpady + padw;
			g.drawLine(j,rpady,j,finaly);
		}
		//g.fillRect(lpadx,lpady,padt,padw);
		//g.fillRect(rpadx,rpady,padt,padw);
		//g.fillRect(lpady-padHalfWidth,lpadxl,lpady+padHalfWidth,lpadxr);
		//g.fillRect(rpady-padHalfWidth,rpadxl,rpady+padHalfWidth,rpadxr);
		//g.drawLine(0,0,20,20);

		//g.setColor(oldColor);
	}
	
	public void go()
	{
		p = new Painter(this);
		//t = new Ticker(this);
		if(p != null)
			p.start();
	//	if(t != null)
	//		t.start();
	//	else
	//		System.out.println("nulled");
	}

	public void stop()
	{
		p.going = false;
		//t.going = false;
	}


	public void calcPos()
	{
		theBall.xPos += theBall.xVel;
		theBall.yPos += theBall.yVel;
		if(padUp)
			rpady -= 10;
		if(padDown)
			rpady += 10;
		if(lpadUp)
			lpady -= 10;
		if(lpadDown)
			lpady += 10;
		if(rpady < 0)
		{
			rpady = 0;
			rpadVel = 0;
		}
		if(rpady > HEIGHT - padw)
		{
			rpady = HEIGHT -padw;
			rpadVel =0;
		}
		if(lpady < 0)
		{
			lpady = 0;
			lpadVel = 0;
		}
		if(lpady > HEIGHT - padw)
		{
			lpady = HEIGHT -padw;
			lpadVel =0;
		}
			
		if(theBall.xPos < lpadx + padt + theBall.RADIUS)
		{
			if(theBall.xPos < 0)
			{
				theBall.setXY(WIDTH/2, HEIGHT/2);
				theBall.xVel = ((new Random()).nextInt(6) - 3)*2; 
				theBall.yVel = ((new Random()).nextInt(6) - 3)*2;
				if(theBall.xVel == 0)
					theBall.xVel = 3;
				if(theBall.yVel == 0)
					theBall.yVel = -7;
				lastRScore = rScore++;
				lStruck = rStruck = false;
			}
			else if(
		(theBall.yPos > lpady && theBall.yPos < lpady + padw) || 
		(theBall.lastYPos > lpady && theBall.lastYPos < lpady + padw)
			  )
			{
				if(!lStruck)
				{	
					//theBall.xPos = theBall.xPos - ((int)theBall.xVel)/2;
					theBall.xPos -= 1 >> theBall.xPos;
					theBall.xVel = -theBall.xVel + 2;
					
					if(theBall.yPos > lpady + padw*2/3)
						theBall.yVel += 3;
					if(theBall.yPos < lpady + padw/3)
						theBall.yVel -= 3;
					lStruck = true;
					rStruck = false;
				}
			}
		}
		if(theBall.xPos > rpadx - theBall.RADIUS) 
		{ 
			if(theBall.xPos > WIDTH)
			{
				theBall.setXY(WIDTH/2, HEIGHT/2);
				theBall.xVel = ((new Random()).nextInt(6) - 3)*2; 
				theBall.yVel = ((new Random()).nextInt(6) - 3)*2;
				if(theBall.xVel == 0)
					theBall.xVel = 3;
				if(theBall.yVel == 0)
					theBall.yVel = -7;
				lastLScore = lScore++;
				lStruck = false;
				rStruck = false;
			}
			else if(
		(theBall.yPos > rpady && theBall.yPos < rpady + padw) ||
		(theBall.lastYPos > rpady && theBall.lastYPos < rpady + padw)
				)
			{
				if(!rStruck)
				{
					theBall.xPos -= 1 >> theBall.xPos;
					//theBall.xPos = theBall.xPos - ((int)theBall.xVel)/2;
					theBall.xVel = -theBall.xVel - 2;
					rStruck = true;
					lStruck = false;
				}
			}
		}
		if(theBall.yPos < 0)
		{
			theBall.yPos = - theBall.yPos;
			theBall.yVel = -theBall.yVel;
			lStruck = rStruck = false;
		}
		if(theBall.yPos > HEIGHT - theBall.RADIUS)
		{
			theBall.yPos = HEIGHT - 2*theBall.RADIUS - (theBall.yPos - HEIGHT);
			theBall.yVel = -theBall.yVel;
			lStruck = rStruck = false;
		}
		if(lScore > 15 || rScore > 15)
		{
			stop();
		}
	}

	public void keyUp() { padUp = true; }
	public void keyDown() { padDown = true; }
	public void keyUpStop() { padUp = false; }
	public void keyDownStop(){ padDown = false; }
	public void lKeyUp() { lpadUp = true; }
	public void lKeyDown() { lpadDown = true; }
	public void lKeyUpStop() { lpadUp = false; }
	public void lKeyDownStop(){ lpadDown = false; }
}

	//public int getTicksSince()
	//{
	//	int ticks = ticksSince;
	//	ticksSince = 0;
	//	return 1;
	//}

	//public void tick()
	//{
	//	ticksSince++;
	//}RADIUSRADIUS
