//Joe Bradshaw
//20010224

#include "CRubick.h"
#include <stdio.h>

rubick::rubick(void)
{
  short colors[6] = { 3, 1, 4, 6, 2, 5 };
  for(int i = 0;i < 6; i++)
  {
    for(int j = 0;j < 3; j++)
    {
      for(int k = 0;k < 3; k++)
      {
        cubeArray [i] [j] [k] = colors[i];
      }
    }
  }
  for(int l = 0; l < 15; l++)
    moves[l] = 0;
}
rubick::rubick(short tempCubeArray [6] [3] [3])
{
  for(int i = 0;i < 6; i++)
  {
    for(int j = 0;j < 3; j++)
    {
      for(int k = 0;k < 3; k++)
      {
        cubeArray [i] [j] [k] = tempCubeArray [i] [j] [k];
      }
    }
  }
  for(int l = 0; l < 15; l++)
    moves[l] = 0;
}
void rubick::copyArray(short otherArray [6] [3] [3])
{
  for(int i = 0;i < 6; i++)
  {
    for(int j = 0;j < 3; j++)
    {
      for(int k = 0;k < 3; k++)
      {
        otherArray [i] [j] [k] = cubeArray [i] [j] [k];
      }
    }
  }
}
void rubick::assign(short tempCubeArray [6] [3] [3])
{
  for(int i = 0;i < 6; i++)
  {
    for(int j = 0;j < 3; j++)
    {
      for(int k = 0;k < 3; k++)
      {
        cubeArray [i] [j] [k] = tempCubeArray [i] [j] [k];
      }
    }
  }
}

int rubick::GetQuality(void)
{
	// By establishing a complex weighting scheme for how close the
	// puzzle is to being solved the puzzle can be solved in fewer steps.
	// The quality is slightly improved by each correct square on the
	// top until all the squares are right.  Then the quality is improved
	// for each part of each subsection that is correct with a bonus for
	// closing out a section.
	int quality = 200;
	if((cubeArray [3] [0] [0] == cubeArray [3] [0] [1]) &&
	(cubeArray [3] [0] [1] == cubeArray [3] [0] [2]) &&
	(cubeArray [3] [0] [2] == cubeArray [3] [1] [0]) &&
	(cubeArray [3] [1] [0] == cubeArray [3] [1] [1]) &&
	(cubeArray [3] [1] [1] == cubeArray [3] [1] [2]) &&
	(cubeArray [3] [1] [2] == cubeArray [3] [2] [0]) &&
	(cubeArray [3] [2] [0] == cubeArray [3] [2] [1]) &&
	(cubeArray [3] [2] [1] == cubeArray [3] [2] [2]))
	{
		quality -= 40;
		if((cubeArray [2] [0] [0] == cubeArray [2] [0] [1]) &&
		(cubeArray [2] [0] [1] == cubeArray [2] [0] [2]) &&
		(cubeArray [2] [0] [2] == cubeArray [2] [1] [1]) &&
		(cubeArray [4] [0] [0] == cubeArray [4] [0] [1]) &&
		(cubeArray [4] [0] [1] == cubeArray [4] [0] [2]) &&
		(cubeArray [4] [0] [2] == cubeArray [4] [1] [1]) &&
		(cubeArray [1] [0] [0] == cubeArray [1] [0] [1]) &&
		(cubeArray [1] [0] [1] == cubeArray [1] [0] [2]) &&
		(cubeArray [1] [0] [2] == cubeArray [1] [1] [1]) &&
		(cubeArray [0] [0] [0] == cubeArray [0] [0] [1]) &&
		(cubeArray [0] [0] [1] == cubeArray [0] [0] [2]) &&
		(cubeArray [0] [0] [2] == cubeArray [0] [1] [1]))
		{
			quality -= 50;
		}
		if((cubeArray [1] [1] [0] == cubeArray [1] [1] [1]) &&
		(cubeArray [1] [0] [0] == cubeArray [1] [0] [1]) &&
		(cubeArray [1] [1] [1] == cubeArray [1] [1] [2]) &&
		(cubeArray [1] [2] [0] == cubeArray [1] [2] [1]) &&
		(cubeArray [1] [2] [0] == cubeArray [1] [1] [0]) &&
		(cubeArray [1] [2] [0] == cubeArray [1] [2] [1]) &&
		(cubeArray [1] [2] [0] == cubeArray [1] [1] [0]) &&
		(cubeArray [1] [2] [0] == cubeArray [1] [2] [1]))
		{
			quality -= 20;
		}
		if((cubeArray [2] [2] [0] == cubeArray [2] [1] [1]) &&
		(cubeArray [1] [2] [2] == cubeArray [1] [1] [1]) &&
		(cubeArray [5] [0] [0] == cubeArray [5] [1] [1]) &&
		(cubeArray [1] [2] [0] == cubeArray [1] [1] [1]) &&
		(cubeArray [4] [2] [2] == cubeArray [4] [1] [1]) &&
		(cubeArray [5] [2] [0] == cubeArray [5] [1] [1]) &&
		(cubeArray [4] [2] [0] == cubeArray [4] [1] [1]) &&
		(cubeArray [0] [2] [2] == cubeArray [0] [1] [1]) &&
		(cubeArray [5] [2] [2] == cubeArray [5] [1] [1]) &&
		(cubeArray [0] [2] [0] == cubeArray [0] [1] [1]) &&
		(cubeArray [2] [2] [2] == cubeArray [2] [1] [1]) &&
		(cubeArray [5] [0] [2] == cubeArray [5] [1] [1]))
		{
			quality -= 10;
		}
		if((cubeArray [1] [2] [1] == cubeArray [1] [1] [1]) &&
		(cubeArray [5] [1] [0] == cubeArray [5] [1] [1]) &&
		(cubeArray [4] [2] [1] == cubeArray [4] [1] [1]) &&
		(cubeArray [5] [2] [1] == cubeArray [5] [1] [1]) &&
		(cubeArray [0] [2] [1] == cubeArray [0] [1] [1]) &&
		(cubeArray [5] [1] [2] == cubeArray [5] [1] [1]) &&
		(cubeArray [2] [2] [1] == cubeArray [2] [2] [1]) &&
		(cubeArray [5] [0] [1] == cubeArray [5] [1] [1]))
		{
			quality -= 10;
		}
		if((cubeArray [5] [0] [0] == cubeArray [5] [0] [1]) &&
		(cubeArray [5] [0] [1] == cubeArray [5] [0] [2]) &&
		(cubeArray [5] [0] [2] == cubeArray [5] [1] [0]) &&
		(cubeArray [5] [1] [0] == cubeArray [5] [1] [1]) &&
		(cubeArray [5] [1] [1] == cubeArray [5] [1] [2]) &&
		(cubeArray [5] [1] [2] == cubeArray [5] [2] [0]) &&
		(cubeArray [5] [2] [0] == cubeArray [5] [2] [1]) &&
		(cubeArray [5] [2] [1] == cubeArray [5] [2] [2]) &&
    (cubeArray [3] [0] [0] == cubeArray [3] [0] [1]) &&
		(cubeArray [3] [0] [1] == cubeArray [3] [0] [2]) &&
		(cubeArray [3] [0] [2] == cubeArray [3] [1] [0]) &&
		(cubeArray [3] [1] [0] == cubeArray [3] [1] [1]) &&
		(cubeArray [3] [1] [1] == cubeArray [3] [1] [2]) &&
		(cubeArray [3] [1] [2] == cubeArray [3] [2] [0]) &&
		(cubeArray [3] [2] [0] == cubeArray [3] [2] [1]) &&
		(cubeArray [3] [2] [1] == cubeArray [3] [2] [2]))
		{
			quality -= 10;
		}
		if((cubeArray [1] [2] [1] == cubeArray [1] [1] [1]) &&
		(cubeArray [5] [1] [0] == cubeArray [5] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [4] [2] [1] == cubeArray [4] [1] [1]) &&
		(cubeArray [5] [2] [1] == cubeArray [5] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [0] [2] [1] == cubeArray [0] [1] [1]) &&
		(cubeArray [5] [1] [2] == cubeArray [5] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [2] [2] [1] == cubeArray [2] [1] [1]) &&
		(cubeArray [5] [0] [1] == cubeArray [5] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [2] [2] [0] == cubeArray [2] [1] [1]) &&
		(cubeArray [1] [2] [2] == cubeArray [1] [1] [1]) &&
		(cubeArray [5] [0] [0] == cubeArray [5] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [1] [2] [0] == cubeArray [1] [1] [1]) &&
		(cubeArray [4] [2] [2] == cubeArray [4] [1] [1]) &&
		(cubeArray [5] [2] [0] == cubeArray [5] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [4] [2] [0] == cubeArray [4] [1] [1]) &&
		(cubeArray [0] [2] [2] == cubeArray [0] [1] [1]) &&
		(cubeArray [5] [2] [2] == cubeArray [5] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [0] [2] [0] == cubeArray [0] [1] [1]) &&
		(cubeArray [2] [2] [2] == cubeArray [2] [1] [1]) &&
		(cubeArray [5] [0] [2] == cubeArray [5] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [1] [1] [2] == cubeArray [1] [1] [1]) &&
		(cubeArray [2] [1] [0] == cubeArray [2] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [1] [1] [0] == cubeArray [1] [1] [1]) &&
		(cubeArray [4] [1] [2] == cubeArray [4] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [0] [1] [2] == cubeArray [0] [1] [1]) &&
		(cubeArray [4] [1] [0] == cubeArray [4] [1] [1]))
		{
			quality -= 5;
		}
		if((cubeArray [0] [1] [0] == cubeArray [0] [1] [1]) &&
		(cubeArray [2] [1] [1] == cubeArray [2] [1] [1]))
		{
			quality -= 5;
		}
	}
	else
	{
		if(cubeArray [3] [0] [0] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}
		if(cubeArray [3] [0] [1] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}
		if(cubeArray [3] [0] [2] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}
		if(cubeArray [3] [1] [0] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}
		if(cubeArray [3] [1] [1] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}
		if(cubeArray [3] [1] [2] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}
		if(cubeArray [3] [2] [0] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}
		if(cubeArray [3] [2] [1] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}
		if(cubeArray [3] [2] [2] == cubeArray [3] [1] [1])
		{
			quality -= 5;
		}

	}
	return quality;
}
void rubick::printRube()
{
  for(int i = 0; i < 9; i++)
  {
	  if(!(i % 3)&&i)
      printf("\n");
	  printf(" %d %d %d\t%d %d %d\n", cubeArray [0 + i / 3] [i % 3] [0],
                                    cubeArray [0 + i / 3] [i % 3] [1],
                                    cubeArray [0 + i / 3] [i % 3] [2],
                                    cubeArray [3 + i / 3] [i % 3] [0],
                                    cubeArray [3 + i / 3] [i % 3] [1],
                                    cubeArray [3 + i / 3] [i % 3] [2]);
  }
}
/*bool rubick::operator==(const rubick& aRubick) const
{
          for(int i = 0; i < 6; i++)
                    for(int j = 0; j < 3; j++)
                              for(int k = 0; k < 3; k++)
                              {
                                        if(this->cubeArray [i] [j] [k] != aRubick.cubeArray [i] [j] [k])
                                                  return false;
                              }
          return true;
}
*/
void rubick::TopRot(short FromTop)
{
  short temp;
  for(int i = 0; i < 3; i++)
  {
    temp = cubeArray [2] [FromTop] [i];
    cubeArray [2] [FromTop] [i] = cubeArray [1] [FromTop] [i];
    cubeArray [1] [FromTop] [i] = cubeArray [0] [FromTop] [i];
    cubeArray [0] [FromTop] [i] = cubeArray [4] [FromTop] [i];
    cubeArray [4] [FromTop] [i] = temp;
  }
  if(FromTop == 0)
  {
    temp = cubeArray [3] [0] [0];
    cubeArray [3] [0] [0] = cubeArray [3] [0] [2];
    cubeArray [3] [0] [2] = cubeArray [3] [2] [2];
    cubeArray [3] [2] [2] = cubeArray [3] [2] [0];
    cubeArray [3] [2] [0] = temp;
    temp = cubeArray [3] [0] [1];
    cubeArray [3] [0] [1] = cubeArray [3] [1] [2];
    cubeArray [3] [1] [2] = cubeArray [3] [2] [1];
    cubeArray [3] [2] [1] = cubeArray [3] [1] [0];
    cubeArray [3] [1] [0] = temp;
  }
  if(FromTop == 2)
  {
    temp = cubeArray [5] [0] [0];
    cubeArray [5] [0] [0] = cubeArray [5] [2] [0];
    cubeArray [5] [2] [0] = cubeArray [5] [2] [2];
    cubeArray [5] [2] [2] = cubeArray [5] [0] [2];
    cubeArray [5] [0] [2] = temp;
    temp = cubeArray [5] [0] [1];
    cubeArray [5] [0] [1] = cubeArray [5] [1] [0];
    cubeArray [5] [1] [0] = cubeArray [5] [2] [1];
    cubeArray [5] [2] [1] = cubeArray [5] [1] [2];
    cubeArray [5] [1] [2] = temp;
  }
}

void rubick::FrontRot(short FromFront)
{
  short temp;
  for(int i = 0; i < 3; i++)
  {
    temp = cubeArray [3] [2 - FromFront] [i];
    cubeArray [3] [2 - FromFront] [i] = cubeArray [2] [2 - i] [2 - FromFront];
    cubeArray [2] [2 - i] [2 - FromFront] = cubeArray [5] [FromFront] [2 - i];
    cubeArray [5] [FromFront] [2 - i] = cubeArray [0] [i] [FromFront];
    cubeArray [0] [i] [FromFront] = temp;
  }
  if(FromFront == 0)
  {//jacked
    temp = cubeArray [4] [0] [0];
    cubeArray [4] [0] [0] = cubeArray [4] [2] [0];
    cubeArray [4] [2] [0] = cubeArray [4] [2] [2];
    cubeArray [4] [2] [2] = cubeArray [4] [0] [2];
    cubeArray [4] [0] [2] = temp;
    temp = cubeArray [4] [0] [1];
    cubeArray [4] [0] [1] = cubeArray [4] [1] [0];
    cubeArray [4] [1] [0] = cubeArray [4] [2] [1];
    cubeArray [4] [2] [1] = cubeArray [4] [1] [2];
    cubeArray [4] [1] [2] = temp;
  }
  if(FromFront == 2)
  {
    temp = cubeArray [1] [0] [0];
    cubeArray [1] [0] [0] = cubeArray [1] [0] [2];
    cubeArray [1] [0] [2] = cubeArray [1] [2] [2];
    cubeArray [1] [2] [2] = cubeArray [1] [2] [0];
    cubeArray [1] [2] [0] = temp;
    temp = cubeArray [1] [0] [1];
    cubeArray [1] [0] [1] = cubeArray [1] [1] [2];
    cubeArray [1] [1] [2] = cubeArray [1] [2] [1];
    cubeArray [1] [2] [1] = cubeArray [1] [1] [0];
    cubeArray [1] [1] [0] = temp;
  }
}

void rubick::SideRot(short FromSide)
{
  short temp;
  for(int i = 0; i < 3; i++)
  {
    temp = cubeArray [3] [i] [FromSide];
    cubeArray [3] [i] [FromSide] = cubeArray [1] [2 - i] [2 - FromSide];
    cubeArray [1] [2 - i] [2 - FromSide] = cubeArray [5] [i] [FromSide];
    cubeArray [5] [i] [FromSide] = cubeArray [4] [i] [FromSide];
    cubeArray [4] [i] [FromSide] = temp;
  }
  if(FromSide == 0)
  {
    temp = cubeArray [2] [0] [0];
    cubeArray [2] [0] [0] = cubeArray [2] [2] [0];
    cubeArray [2] [2] [0] = cubeArray [2] [2] [2];
    cubeArray [2] [2] [2] = cubeArray [2] [0] [2];
    cubeArray [2] [0] [2] = temp;
    temp = cubeArray [2] [0] [1];
    cubeArray [2] [0] [1] = cubeArray [2] [1] [0];
    cubeArray [2] [1] [0] = cubeArray [2] [2] [1];
    cubeArray [2] [2] [1] = cubeArray [2] [1] [2];
    cubeArray [2] [1] [2] = temp;
  }
  if(FromSide == 2)
  {
    temp = cubeArray [0] [0] [0];
    cubeArray [0] [0] [0] = cubeArray [0] [0] [2];
    cubeArray [0] [0] [2] = cubeArray [0] [2] [2];
    cubeArray [0] [2] [2] = cubeArray [0] [2] [0];
    cubeArray [0] [2] [0] = temp;
    temp = cubeArray [0] [0] [1];
    cubeArray [0] [0] [1] = cubeArray [0] [1] [2];
    cubeArray [0] [1] [2] = cubeArray [0] [2] [1];
    cubeArray [0] [2] [1] = cubeArray [0] [1] [0];
    cubeArray [0] [1] [0] = temp;
  }
}
void rubick::moveS(short i)
{
  for(int j = 0; j < 15; j++)
    if(moves[j] == 0) break;

  switch(i)
  {
    case 0: moves[j] = i; break;
  	case 1: moves[j] = i;TopRot(0); break;
	  case 2: moves[j] = i;TopRot(1); break;
		case 3: moves[j] = i;TopRot(2); break;
  	case 4: moves[j] = i;FrontRot(0); break;
	  case 5: moves[j] = i;FrontRot(1); break;
		case 6: moves[j] = i;FrontRot(2); break;
  	case 7: moves[j] = i;SideRot(0); break;
	  case 8: moves[j] = i;SideRot(1); break;
		case 9: moves[j] = i;SideRot(2); break;
  	case 10: moves[j] = i;TopRot(0);TopRot(0);TopRot(0); break;
	  case 11: moves[j] = i;TopRot(1);TopRot(1);TopRot(1); break;
		case 12: moves[j] = i;TopRot(2);TopRot(2);TopRot(2); break;
  	case 13: moves[j] = i;FrontRot(0);FrontRot(0);FrontRot(0); break;
	  case 14: moves[j] = i;FrontRot(1);FrontRot(1);FrontRot(1); break;
		case 15: moves[j] = i;FrontRot(2);FrontRot(2);FrontRot(2); break;
  	case 16: moves[j] = i;SideRot(0);SideRot(0);SideRot(0); break;
	  case 17: moves[j] = i;SideRot(1);SideRot(1);SideRot(1); break;
		case 18: moves[j] = i;SideRot(2);SideRot(2);SideRot(2); break;
  	case 19: moves[j] = i;TopRot(0);TopRot(0); break;
	  case 20: moves[j] = i;TopRot(1);TopRot(1); break;
		case 21: moves[j] = i;TopRot(2);TopRot(2); break;
  	case 22: moves[j] = i;FrontRot(0);FrontRot(0); break;
	  case 23: moves[j] = i;FrontRot(1);FrontRot(1); break;
		case 24: moves[j] = i;FrontRot(2);FrontRot(2); break;
  	case 25: moves[j] = i;SideRot(0);SideRot(0); break;
	  case 26: moves[j] = i;SideRot(1);SideRot(1); break;
		case 27: moves[j] = i;SideRot(2);SideRot(2); break;
  }
}

void rubick::move(short i)
{
	switch(i)
	{
		case 1: TopRot(0); break;
		case 2: TopRot(1); break;
		case 3: TopRot(2); break;
		case 4: FrontRot(0); break;
		case 5: FrontRot(1); break;
		case 6: FrontRot(2); break;
		case 7: SideRot(0); break;
		case 8: SideRot(1); break;
		case 9: SideRot(2); break;
     // This is faster than creating and using a rotate backward move (i.e. BackTopRot)
		case 10: TopRot(0);TopRot(0);TopRot(0); break;
		case 11: TopRot(1);TopRot(1);TopRot(1); break;
		case 12: TopRot(2);TopRot(2);TopRot(2); break;
		case 13: FrontRot(0);FrontRot(0);FrontRot(0); break;
		case 14: FrontRot(1);FrontRot(1);FrontRot(1); break;
		case 15: FrontRot(2);FrontRot(2);FrontRot(2); break;
		case 16: SideRot(0);SideRot(0);SideRot(0); break;
		case 17: SideRot(1);SideRot(1);SideRot(1); break;
		case 18: SideRot(2);SideRot(2);SideRot(2); break;
		case 19: TopRot(0);TopRot(0); break;
		case 20: TopRot(1);TopRot(1); break;
		case 21: TopRot(2);TopRot(2); break;
		case 22: FrontRot(0);FrontRot(0); break;
		case 23: FrontRot(1);FrontRot(1); break;
		case 24: FrontRot(2);FrontRot(2); break;
		case 25: SideRot(0);SideRot(0); break;
		case 26: SideRot(1);SideRot(1); break;
		case 27: SideRot(2);SideRot(2); break;
    default: break;
  }
}

int rubick::comparePRube(rubick* second)
{
  if((cubeArray[0] [0] [0] == second->cubeArray[0] [0] [0])&&
     (cubeArray[0] [0] [1] == second->cubeArray[0] [0] [1])&&
     (cubeArray[0] [0] [2] == second->cubeArray[0] [0] [2])&&
     (cubeArray[0] [1] [0] == second->cubeArray[0] [1] [0])&&
     (cubeArray[0] [1] [1] == second->cubeArray[0] [1] [1])&&
     (cubeArray[0] [1] [2] == second->cubeArray[0] [1] [2])&&
     (cubeArray[0] [2] [0] == second->cubeArray[0] [2] [0])&&
     (cubeArray[0] [2] [1] == second->cubeArray[0] [2] [1])&&
     (cubeArray[0] [2] [2] == second->cubeArray[0] [2] [2])&&
     (cubeArray[1] [0] [0] == second->cubeArray[1] [0] [0])&&
     (cubeArray[1] [0] [1] == second->cubeArray[1] [0] [1])&&
     (cubeArray[1] [0] [2] == second->cubeArray[1] [0] [2])&&
     (cubeArray[1] [1] [0] == second->cubeArray[1] [1] [0])&&
     (cubeArray[1] [1] [1] == second->cubeArray[1] [1] [1])&&
     (cubeArray[1] [1] [2] == second->cubeArray[1] [1] [2])&&
     (cubeArray[1] [2] [0] == second->cubeArray[1] [2] [0])&&
     (cubeArray[1] [2] [1] == second->cubeArray[1] [2] [1])&&
     (cubeArray[1] [2] [2] == second->cubeArray[1] [2] [2])&&
     (cubeArray[2] [0] [0] == second->cubeArray[2] [0] [0])&&
     (cubeArray[2] [0] [1] == second->cubeArray[2] [0] [1])&&
     (cubeArray[2] [0] [2] == second->cubeArray[2] [0] [2])&&
     (cubeArray[2] [1] [0] == second->cubeArray[2] [1] [0])&&
     (cubeArray[2] [1] [1] == second->cubeArray[2] [1] [1])&&
     (cubeArray[2] [1] [2] == second->cubeArray[2] [1] [2])&&
     (cubeArray[2] [2] [0] == second->cubeArray[2] [2] [0])&&
     (cubeArray[2] [2] [1] == second->cubeArray[2] [2] [1])&&
     (cubeArray[2] [2] [2] == second->cubeArray[2] [2] [2])&&
     (cubeArray[3] [0] [0] == second->cubeArray[3] [0] [0])&&
     (cubeArray[3] [0] [1] == second->cubeArray[3] [0] [1])&&
     (cubeArray[3] [0] [2] == second->cubeArray[3] [0] [2])&&
     (cubeArray[3] [1] [0] == second->cubeArray[3] [1] [0])&&
     (cubeArray[3] [1] [1] == second->cubeArray[3] [1] [1])&&
     (cubeArray[3] [1] [2] == second->cubeArray[3] [1] [2])&&
     (cubeArray[3] [2] [0] == second->cubeArray[3] [2] [0])&&
     (cubeArray[3] [2] [1] == second->cubeArray[3] [2] [1])&&
     (cubeArray[3] [2] [2] == second->cubeArray[3] [2] [2])&&
     (cubeArray[4] [0] [0] == second->cubeArray[4] [0] [0])&&
     (cubeArray[4] [0] [1] == second->cubeArray[4] [0] [1])&&
     (cubeArray[4] [0] [2] == second->cubeArray[4] [0] [2])&&
     (cubeArray[4] [1] [0] == second->cubeArray[4] [1] [0])&&
     (cubeArray[4] [1] [1] == second->cubeArray[4] [1] [1])&&
     (cubeArray[4] [1] [2] == second->cubeArray[4] [1] [2])&&
     (cubeArray[4] [2] [0] == second->cubeArray[4] [2] [0])&&
     (cubeArray[4] [2] [1] == second->cubeArray[4] [2] [1])&&
     (cubeArray[4] [2] [2] == second->cubeArray[4] [2] [2])&&
     (cubeArray[5] [0] [0] == second->cubeArray[5] [0] [0])&&
     (cubeArray[5] [0] [1] == second->cubeArray[5] [0] [1])&&
     (cubeArray[5] [0] [2] == second->cubeArray[5] [0] [2])&&
     (cubeArray[5] [1] [0] == second->cubeArray[5] [1] [0])&&
     (cubeArray[5] [1] [1] == second->cubeArray[5] [1] [1])&&
     (cubeArray[5] [1] [2] == second->cubeArray[5] [1] [2])&&
     (cubeArray[5] [2] [0] == second->cubeArray[5] [2] [0])&&
     (cubeArray[5] [2] [1] == second->cubeArray[5] [2] [1])&&
     (cubeArray[5] [2] [2] == second->cubeArray[5] [2] [2]))
  {
    return 1;
  }
  return 0;
}

 