// Joe Bradshaw
// 20010419

// Borland
#pragma hdrstop

// Includes
#include <stdio.h>
#include <conio.h>
#include <list>

#include "CRubick.h"
using namespace std;

// Functions
void parseMoves(short moveList[], rubick&);
void parseMoves(short move, rubick&);
void updateDispList(short moveList[], short DisplayList[]);
void incrMoves(short moveList[]);


// Borland.  Maybe I'll get the starting cube from the command line eventually
//#pragma argsused

//---------------------------------------------------------------------------
// Main
int main(int argc, char* argv[])
{
  // Variables
  short tempCubeArray [6] [3] [3] = {{{3,3,3},{3,3,3},{3,3,3}},  //0right
                                     {{1,1,1},{1,1,1},{1,1,1}},  //1back 
                                     {{4,4,4},{4,4,4},{4,4,4}},  //2left
                                     {{6,6,6},{6,6,6},{6,6,6}},  //3top
                                     {{2,2,2},{2,2,2},{2,2,2}},  //4front
                                     {{5,5,5},{5,5,5},{5,5,5}}}; //5bottom

  // a test cube array soln 3 17 5 20
  //short tempCubeArray [6] [3] [3] = {{{3,5,3},{4,5,4},{1,5,1}},  //0right
  //                                   {{1,5,1},{2,3,2},{4,6,4}},  //1back 
  //                                   {{4,6,4},{3,6,3},{2,6,2}},  //2left
  //                                   {{6,1,6},{3,2,3},{6,1,6}},  //3top
  //                                   {{2,6,2},{1,4,1},{3,5,3}},  //4front
  //                                   {{5,4,5},{2,1,2},{5,4,5}}}; //5bottom
  //

  rubick dRube, oldRube, origRube, bestRube;
  rubick *pRube = 0;
  list<rubick *> rubeList;
  
  short qCheck, qCheck1, bestqCheck;
  long int loopCount;
  // List of moves being tested
  short moveList[listLen] = {0};
  // A list of 27 solution cubes will be stored.  The anti-moves associated
  // with a solution cube can be applied to solve the cube.
  short antiMoves[28] = {0};
  // The best looking solutions are saved each iteration
  short savedMoves[listLen] = {0};
  // The best moves of each iteration are added to the end of the Display list
  // which will eventually hold the full solution.
  short DisplayList[200] = {0};
  //short bonusMoves[4] = {0};
  // Checking for memory leaks with this variable
  short objects = 0;
  int i;
  // Assign cube
  dRube.assign(tempCubeArray);

  // Create list of solution cubes to search an extra 1 move for solution
  //for(i = 0; i <= 27; i++)
  //{
  //  pRube = new rubick();
  //  objects++;
  //  //(*pRube).assign(tempCubeArray);
  //  (*pRube).moveS(i);
  //  rubeList.push_front(pRube);
  //}
//  rubeList.reserve(615000);
  for(i = 0; i <= 27; i++)
  {
    for(int j = 0; j <= 27; j++)
    {
      for(int k = 0; k <= 27; k++)
      {
        pRube = new rubick(tempCubeArray);
        objects ++;
        (*pRube).moveS(i);
        (*pRube).moveS(j);
        (*pRube).moveS(k);
        rubeList.push_front(pRube);
      }
    }
  }

  // Finished with pRube here
  pRube = 0;
  printf("Objects:%d\n", objects);
  getch();

  // Mixing cube for testing
  dRube.SideRot(2);
  dRube.SideRot(2);
  dRube.TopRot(0);
  dRube.TopRot(0);
  dRube.TopRot(0);
  dRube.FrontRot(0);
  dRube.FrontRot(0);
  dRube.FrontRot(0);
  //dRube.TopRot(1);
  dRube.SideRot(0);
  dRube.SideRot(0);
  dRube.SideRot(0);
  //dRube.TopRot(1);
  //dRube.FrontRot(1);
  //dRube.SideRot(0);
  //dRube.SideRot(0);
  //dRube.FrontRot(2);

  // Test soln
  //dRube.TopRot(0);
  //dRube.TopRot(2);


  // Solve puzzle

  // Initialize a few things
  origRube = dRube;
  oldRube = dRube;
  qCheck = dRube.GetQuality();
  qCheck1 = oldRube.GetQuality();
  list<rubick *>::iterator rIter = rubeList.begin();
  loopCount = 0;
  bool flipIt = false; // an inelegant way of remembering to reset the iterator

  // Begining quality
  printf("\n\n=====\nStart: %d\n", qCheck);
  printf("=====\n\n");
  
  while (qCheck != 0)
  {
    // Sometimes I use the mode.  Right now I'm not.
	  // Set Quality Mode 1 = Everything, 2 = One Side, 3 = One Side and
  	// Edges, 4 = One Side and All Corners/Edges, 5 = Everything
    // Currently there is no "do nothing" move -- all moves alter the cube.
  	// Assemble listLen-move move-list


    if(rIter == rubeList.end())
    {
      if(flipIt == true)
      {
        incrMoves(moveList);
        rIter = rubeList.begin();
        flipIt = false;
      }
      else
        flipIt = true;
    }

    parseMoves(moveList, dRube);    
    // A solution set of cubes has been stored in memory.  If the current cube
    // matches a solution cube the anti-moves associated with the solution
    // cube can be applied to the cube to solve it.  I theorize that most
    // useful moves are somewhat symetric with a central adjustment move.
    // this means that odd numbers of moves are more likely to be successful.
    // At subscript 3, there are 4 moves.  The solution set has an additional
    // move making the total 5.
//    if(moveList[5] == 1 && moveList[4] == 4)
//    {
//      int iMove = 812;
//      for(rIter = rubeList.begin(); rIter != rubeList.end(); rIter++)
//      {
//        iMove--;
//        if((moveList[0] == 12)&&(moveList[1] == 15)&&(moveList[2] == 16)&&
//          (moveList[3] == 11)&&(moveList[4] == 15))
//        {
//          (*rIter)->printRube();
//          printf("\n-->%d<--\n", iMove);
//        }
//        if((dRube.comparePRube(*rIter)) == 1)
//        {
//          printf("\nMatched Cube: \n");
//          dRube.printRube();
//          printf("\n");
//          //(*rIter)->printRube();
//          int j;
//          for(j = listLen - 1; j != 0; j--)
//            if(moveList[j] != 0 )
//              break;
//          //printf("\n-->%d<--\n", iMove);
//          //moveList[j + 1] = antiMoves[iMove];
//          if((*rIter)->antiMoves[1] != 0)
//          {
//            moveList[j + 1] = (*rIter)->antiMoves[1];
//            moveList[j + 2] = (*rIter)->antiMoves[0];
//          }
//          else if((*rIter)->antiMoves[0] != 0)
//          {
//            moveList[j + 1] = (*rIter)->antiMoves[0];
//          }
//            
//          dRube = oldRube;
//          parseMoves(moveList, dRube);
//          if(dRube.GetQuality() != 0)
//            printf("!!!! Failure !!!!");
//          else printf("Solved Quality: %d", dRube.GetQuality());
//          printf("\nThe Special Moves: ");
//          for(i = 0; i < 11; i++)
//           	printf("%d  ", moveList[i]);
//          break;
//        }
//      }
//    }
    qCheck = dRube.GetQuality();

  	// Report Status
	  loopCount++;
  	if(loopCount == 556836) // put a five in front to slow things down
	  {
		  printf("\nCurrent Moves: ");
  		for(i = 0; i < 11; i++)
	  	{
		  	printf("%d  ", moveList[i]);
  		}
	  	loopCount = 0;
  	}

    // If the quality is better or puzzle's solved
  	if((qCheck < qCheck1)||(moveList[4] > 16))
	  {
      // If move 5 is 16, we've been running long enough and need to pick the
      // best of what we have and move on
      if((moveList[4] > 16)||(qCheck == 0))
      {
        // This latest one probably isn't the best but we must be sure
        if(qCheck >= bestqCheck)
        {
          dRube = oldRube;
          parseMoves(antiMoves[0], dRube);
          pRube = &bestRube;
          if(dRube.comparePRube(pRube) != 0)
          {
            printf("error, bogus rube");
            pRube = 0;
            break;
          }
          pRube = 0;
        }
        else  // The latest really is the best
        {
          updateDispList(moveList, DisplayList);
          oldRube = dRube;
  	      qCheck1 = oldRube.GetQuality();
        }
      }
      else
      {
        bestRube = dRube;
        qCheck1 = dRube.GetQuality();
        bestqCheck = qCheck1;
        for(i = 0; i < listLen; i++)
        {
          savedMoves[i] = moveList[i] ;
        }
        dRube = oldRube;
      }
    }
    else dRube = oldRube;
    rIter++;
  }// End loop to solve

  qCheck = dRube.GetQuality();
  printf("\n");
  origRube.printRube();
  printf("\n\n");
  dRube.printRube();
  printf("\n");
  printf("!! \
    Solved !!\n");
  printf("The Quality = %d\n", qCheck);
  printf("The Moves = ");

  //printf(" %d", DisplayList[0]);
  for (i = 0; i < 200; i++)
  {
	  if (DisplayList[i] != 0)
  	{
	  	printf("%d ", DisplayList[i]);
	  }
  }

  // Clean up
  rIter = rubeList.begin();
  while(pRube = rubeList.front())
  {
    if(objects == 0)
    {
      printf("Failed");
      break;
    }
    objects--;
    //printf("\nQuality %d", (*pRube).GetQuality());
    rubeList.pop_front();
    delete pRube;
  }
  printf("Objects:%d", objects);
  //getch();
  return 0;
}//main

// Functions
void incrMoves(short moveList[listLen])
{
  int last, sub;
 	if(moveList[0] == 27)
  {
	  moveList[0] = 1;
 		sub = 1;
    do
    {
      last = sub;
      if(++moveList[sub] == 28)
        moveList[sub++] = 1;
    } while((last != sub)&&(sub < listLen));
  }
  else moveList[0]++;
}
void updateDispList(short moveList[listLen], short DisplayList[200])
{
  int j = 200; // Last subscript of array + 1
  // Change to subscript of trailing zero
  while((DisplayList[--j] == 0)&&(j != 0))
    ;
  int i = 0;
  while((moveList[i] != 0)&&(i < listLen))
  {
    DisplayList[i + j + 1] = moveList[i];
    i++;
  }
  for(i = 0; i < listLen; i++)
  {
    moveList[i] = 0;
  }
}
// This is faster if it's in main
void parseMoves(short moveList[listLen], rubick& dRube)
{
  int i = 0;
	while(moveList[i] != 0)
	{
		//	printf("%f\n", qCheck);
		switch(moveList[i])
		{
			case 1: dRube.TopRot(0); break;
			case 2: dRube.TopRot(1); break;
			case 3: dRube.TopRot(2); break;
			case 4: dRube.FrontRot(0); break;
			case 5: dRube.FrontRot(1); break;
			case 6: dRube.FrontRot(2); break;
			case 7: dRube.SideRot(0); break;
			case 8: dRube.SideRot(1); break;
			case 9: dRube.SideRot(2); break;
      // This is faster than creating and using a rotate backward move (i.e. BackTopRot)
			case 10: dRube.TopRot(0);dRube.TopRot(0);dRube.TopRot(0); break;
			case 11: dRube.TopRot(1);dRube.TopRot(1);dRube.TopRot(1); break;
			case 12: dRube.TopRot(2);dRube.TopRot(2);dRube.TopRot(2); break;
			case 13: dRube.FrontRot(0);dRube.FrontRot(0);dRube.FrontRot(0); break;
			case 14: dRube.FrontRot(1);dRube.FrontRot(1);dRube.FrontRot(1); break;
			case 15: dRube.FrontRot(2);dRube.FrontRot(2);dRube.FrontRot(2); break;
			case 16: dRube.SideRot(0);dRube.SideRot(0);dRube.SideRot(0); break;
			case 17: dRube.SideRot(1);dRube.SideRot(1);dRube.SideRot(1); break;
			case 18: dRube.SideRot(2);dRube.SideRot(2);dRube.SideRot(2); break;
			case 19: dRube.TopRot(0);dRube.TopRot(0); break;
			case 20: dRube.TopRot(1);dRube.TopRot(1); break;
			case 21: dRube.TopRot(2);dRube.TopRot(2); break;
			case 22: dRube.FrontRot(0);dRube.FrontRot(0); break;
			case 23: dRube.FrontRot(1);dRube.FrontRot(1); break;
			case 24: dRube.FrontRot(2);dRube.FrontRot(2); break;
			case 25: dRube.SideRot(0);dRube.SideRot(0); break;
			case 26: dRube.SideRot(1);dRube.SideRot(1); break;
			case 27: dRube.SideRot(2);dRube.SideRot(2); break;
		}
		i++;
	}
}
void parseMoves(short move, rubick& dRube)
{
  //	printf("%f\n", qCheck);
	switch(move)
	{
		case 1: dRube.TopRot(0); break;
		case 2: dRube.TopRot(1); break;
		case 3: dRube.TopRot(2); break;
		case 4: dRube.FrontRot(0); break;
		case 5: dRube.FrontRot(1); break;
		case 6: dRube.FrontRot(2); break;
		case 7: dRube.SideRot(0); break;
		case 8: dRube.SideRot(1); break;
		case 9: dRube.SideRot(2); break;
     // This is faster than creating and using a rotate backward move (i.e. BackTopRot)
		case 10: dRube.TopRot(0);dRube.TopRot(0);dRube.TopRot(0); break;
		case 11: dRube.TopRot(1);dRube.TopRot(1);dRube.TopRot(1); break;
		case 12: dRube.TopRot(2);dRube.TopRot(2);dRube.TopRot(2); break;
		case 13: dRube.FrontRot(0);dRube.FrontRot(0);dRube.FrontRot(0); break;
		case 14: dRube.FrontRot(1);dRube.FrontRot(1);dRube.FrontRot(1); break;
		case 15: dRube.FrontRot(2);dRube.FrontRot(2);dRube.FrontRot(2); break;
		case 16: dRube.SideRot(0);dRube.SideRot(0);dRube.SideRot(0); break;
		case 17: dRube.SideRot(1);dRube.SideRot(1);dRube.SideRot(1); break;
		case 18: dRube.SideRot(2);dRube.SideRot(2);dRube.SideRot(2); break;
		case 19: dRube.TopRot(0);dRube.TopRot(0); break;
		case 20: dRube.TopRot(1);dRube.TopRot(1); break;
		case 21: dRube.TopRot(2);dRube.TopRot(2); break;
		case 22: dRube.FrontRot(0);dRube.FrontRot(0); break;
		case 23: dRube.FrontRot(1);dRube.FrontRot(1); break;
		case 24: dRube.FrontRot(2);dRube.FrontRot(2); break;
		case 25: dRube.SideRot(0);dRube.SideRot(0); break;
		case 26: dRube.SideRot(1);dRube.SideRot(1); break;
		case 27: dRube.SideRot(2);dRube.SideRot(2); break;
  }
}
//#include <std.h>
//#include <string>

  // Test solution matching

  //rubeList::iterator++
  //while(!rubeList.empty())
  //{
  //          pRube rIter
  //          pRube = rubeList::
  //          delete pRube;
  //}
  //for(int i = 1; i < 27; i++)
  //{
  //          if(dRube == *

  // Initialize a move-list for testing
  //for (i = 0;i < listLen;i++)
  //{
  //	moveList[i] = 0;
  //	if (i < 10)
  //	{
  //		moveList[i] = 10 + i;
  //	}
  //}
//qCheck = dRube.GetQuality();
//printf("\nNew Move, MoveSub: %d,%d", (*rIter)->moves[0], j + 1);
//printf("  Q: %d", qCheck);
//getch();
//printf("\nSolved Compared Cube:\n");
//(*rIter)->printRube();
//printf("\nActual Cube:\n");
//dRube.printRube();
//void rubick::TopRotB(short FromTop)
//{
//  short temp;
//  for(int i = 0; i < 3; i++)
//  {
//    temp = cubeArray [2] [FromTop] [i];
//    cubeArray [2] [FromTop] [i] = cubeArray [0] [FromTop] [i];
//    cubeArray [0] [FromTop] [i] = cubeArray [4] [FromTop] [i];
//   cubeArray [4] [FromTop] [i] = cubeArray [1] [FromTop] [i];
//    cubeArray [1] [FromTop] [i] = temp;
//  }
//}
//void rubick::TopRotX(short FromTop)
//{
//  short temp;
//  for(int i = 0; i < 3; i++)
//  {
//    temp = cubeArray [2] [FromTop] [i];
//    cubeArray [2] [FromTop] [i] = cubeArray [4] [FromTop] [i];
//    cubeArray [4] [FromTop] [i] = temp;
//    temp = cubeArray [0] [FromTop] [i];
//    cubeArray [0] [FromTop] [i] = cubeArray [1] [FromTop] [i];
//    cubeArray [1] [FromTop] [i] = temp;
//  }
//}

//void rubick::FrontRotB(short FromFront)
//{
//  short temp;
//  for(int i = 0; i < 3; i++)
//  {
//    temp = cubeArray [3] [2 - FromFront] [i];
//    cubeArray [3] [2 - FromFront] [i] = cubeArray [0] [i] [FromFront];
//    cubeArray [0] [i] [FromFront] = cubeArray [5] [FromFront] [i];
//    cubeArray [5] [FromFront] [i] = cubeArray [1] [i] [2 - FromFront];
//    cubeArray [1] [i] [2 - FromFront] = temp;
//  }
//}
//void rubick::FrontRotX(short FromFront)
//{
//  short temp;
//  for(int i = 0; i < 3; i++)
//  {
//    temp = cubeArray [3] [2 - FromFront] [i];
//    cubeArray [3] [2 - FromFront] [i] = cubeArray [5] [FromFront] [i];
//    cubeArray [5] [FromFront] [i] = temp;
//    temp = cubeArray [0] [FromFront] [i];
//    cubeArray [0] [i] [FromFront] = cubeArray [1] [i] [2 - FromFront];
//    cubeArray [1] [i] [2 - FromFront] = temp;
//  }
//}

//void rubick::SideRotB(short FromSide)
//{
//  short temp;
//  for(int i = 0; i < 3; i++)
//  {
//    temp = cubeArray [3] [i] [FromSide];
//    cubeArray [3] [i] [FromSide] = cubeArray [2] [i] [FromSide];
//    cubeArray [2] [i] [FromSide] = cubeArray [5] [i] [FromSide];
//    cubeArray [5] [i] [FromSide] = cubeArray [4] [2 - i] [2 - FromSide];
//    cubeArray [4] [2 - i] [2 - FromSide] = temp;
//  }
//}
//void rubick::SideRotX(short FromSide)
//{
//  short temp;
//  for(int i = 0; i < 3; i++)
//  {
//    temp = cubeArray [3] [i] [FromSide];
//    cubeArray [3] [i] [FromSide] = cubeArray [5] [i] [FromSide];
//    cubeArray [5] [i] [FromSide] = temp;
//    temp = cubeArray [2] [i] [FromSide];
//    cubeArray [2] [i] [FromSide] = cubeArray [4] [2 - i] [2 - FromSide];
//    cubeArray [4] [2 - i] [2 - FromSide] = temp;
//  }
//}

//---------------------------------------------------------------------------
/*	double q1, q2, q3, q4, q5, q6;
	short i, j;
	double sum1, sum2, sum3, sum4, sum5, sum6;
	q1 = q2 = q3 = q4 = q5 = q6 = 0;
	sum1 = sum2 = sum3 = sum4 = sum5 = sum6 = 0;
	for (i = 0;i<3;i++)
	{
		for (j = 0;j<3;j++)
		{
			sum1 += (scArCubeSet [0] [i] [j]).Rtop();
			sum2 += (scArCubeSet [2] [i] [j]).Rbottom();
			sum3 += (scArCubeSet [i] [0] [j]).Rfront();
			sum4 += (scArCubeSet [i] [2] [j]).Rback();
			sum5 += (scArCubeSet [i] [j] [0]).Rleft_side();
			sum6 += (scArCubeSet [i] [j] [2]).Rright_side();
		}
	}
	sum1 /= 9;
	sum2 /= 9;
	sum3 /= 9;
	sum4 /= 9;
	sum5 /= 9;
	sum6 /= 9;
	for (i = 0; i < 3; i++)
	{
		for (j = 0; j < 3; j++)
		{
		       q4 += fabs(sum4 - (scArCubeSet [i] [2] [j]).Rback());
		       q1 += fabs(sum1 - (scArCubeSet [0] [i] [j]).Rtop());
		       q2 += fabs(sum2 - (scArCubeSet [2] [i] [j]).Rbottom());
		       q3 += fabs(sum3 - (scArCubeSet [i] [0] [j]).Rfront());
		       q5 += fabs(sum5 - (scArCubeSet [i] [j] [0]).Rleft_side());
		       q6 += fabs(sum6 - (scArCubeSet [i] [j] [2]).Rright_side());
		}
	}
	return q1 + q2 + q3 + q4 + q5 + q6;
 */
 /*
{
	subcube temp;
	subcube temp1;
	temp = scArCubeSet [FromTop] [0] [0];
	temp1 = scArCubeSet [FromTop] [0] [1];
	(scArCubeSet [FromTop] [0] [2]).SubTopRotB();
	scArCubeSet [FromTop] [0] [0] = scArCubeSet [FromTop] [0] [2];
	(scArCubeSet [FromTop] [1] [2]).SubTopRotB();
	scArCubeSet [FromTop] [0] [1] = scArCubeSet [FromTop] [1] [2];
	(scArCubeSet [FromTop] [2] [2]).SubTopRotB();
	scArCubeSet [FromTop] [0] [2] = scArCubeSet [FromTop] [2] [2];
	(scArCubeSet [FromTop] [2] [1]).SubTopRotB();
	scArCubeSet [FromTop] [1] [2] = scArCubeSet [FromTop] [2] [1];
	(scArCubeSet [FromTop] [2] [0]).SubTopRotB();
	scArCubeSet [FromTop] [2] [2] = scArCubeSet [FromTop] [2] [0];
	(scArCubeSet [FromTop] [1] [0]).SubTopRotB();
	scArCubeSet [FromTop] [2] [1] = scArCubeSet [FromTop] [1] [0];
	(temp).SubTopRotB();
	scArCubeSet [FromTop] [2] [0] = temp;
	(temp1).SubTopRotB();
	scArCubeSet [FromTop] [1] [0] = temp1;
	return 1;
}

{
	subcube temp;
	temp = scArCubeSet [FromTop] [0] [0];
  (scArCubeSet [FromTop] [2] [2]).SubTopRotX();
  scArCubeSet [FromTop] [0] [0] = scArCubeSet [FromTop] [2] [2];
  temp.SubTopRotX();
  scArCubeSet [FromTop] [2] [2] = temp;
	temp = scArCubeSet [FromTop] [0] [1];
	(scArCubeSet [FromTop] [2] [1]).SubTopRotX();
  scArCubeSet [FromTop] [0] [1] = scArCubeSet [FromTop] [2] [1];
  temp.SubTopRotX();
  scArCubeSet [FromTop] [2] [1] = temp;
  temp = scArCubeSet [FromTop] [0] [2];
  (scArCubeSet [FromTop] [2] [0]).SubTopRotX();
  scArCubeSet [FromTop] [0] [2] = scArCubeSet [FromTop] [2] [0];
  temp.SubTopRotX();
  scArCubeSet [FromTop] [2] [0] = temp;
  temp = scArCubeSet [FromTop] [1] [0];
  (scArCubeSet [FromTop] [1] [2]).SubTopRotX();
  scArCubeSet [FromTop] [1] [0] = scArCubeSet [FromTop] [1] [2];
  temp.SubTopRotX();
  scArCubeSet [FromTop] [1] [2] = temp;
	return 1;
}

{
	subcube temp;
	subcube temp1;
	temp = scArCubeSet [0] [FromFront] [0];
	temp1 = scArCubeSet [0] [FromFront] [1];
	(scArCubeSet [2] [FromFront] [0]).SubFrontRot();
	scArCubeSet [0] [FromFront] [0] = scArCubeSet [2] [FromFront] [0];
	(scArCubeSet [1] [FromFront] [0]).SubFrontRot();
	scArCubeSet [0] [FromFront] [1] = scArCubeSet [1] [FromFront] [0];
	(scArCubeSet [2] [FromFront] [2]).SubFrontRot();
	scArCubeSet [2] [FromFront] [0] = scArCubeSet [2] [FromFront] [2];
	(scArCubeSet [2] [FromFront] [1]).SubFrontRot();
	scArCubeSet [1] [FromFront] [0] = scArCubeSet [2] [FromFront] [1];
	(scArCubeSet [0] [FromFront] [2]).SubFrontRot();
	scArCubeSet [2] [FromFront] [2] = scArCubeSet [0] [FromFront] [2];
	(scArCubeSet [1] [FromFront] [2]).SubFrontRot();
	scArCubeSet [2] [FromFront] [1] = scArCubeSet [1] [FromFront] [2];
	(temp).SubFrontRot();
	scArCubeSet [0] [FromFront] [2] = temp;
	(temp1).SubFrontRot();
	scArCubeSet [1] [FromFront] [2] = temp1;
	return 1;
}

{
	subcube temp;
	subcube temp1;
	temp = scArCubeSet [0] [FromFront] [0];
	temp1 = scArCubeSet [0] [FromFront] [1];
	(scArCubeSet [0] [FromFront] [2]).SubFrontRotB();
	scArCubeSet [0] [FromFront] [0] = scArCubeSet [0] [FromFront] [2];
	(scArCubeSet [1] [FromFront] [2]).SubFrontRotB();
	scArCubeSet [0] [FromFront] [1] = scArCubeSet [1] [FromFront] [2];
	(scArCubeSet [2] [FromFront] [2]).SubFrontRotB();
	scArCubeSet [0] [FromFront] [2] = scArCubeSet [2] [FromFront] [2];
	(scArCubeSet [2] [FromFront] [1]).SubFrontRotB();
	scArCubeSet [1] [FromFront] [2] = scArCubeSet [2] [FromFront] [1];
	(scArCubeSet [2] [FromFront] [0]).SubFrontRotB();
	scArCubeSet [2] [FromFront] [2] = scArCubeSet [2] [FromFront] [0];
	(scArCubeSet [1] [FromFront] [0]).SubFrontRotB();
	scArCubeSet [2] [FromFront] [1] = scArCubeSet [1] [FromFront] [0];
	(temp).SubFrontRotB();
	scArCubeSet [2] [FromFront] [0] = temp;
	(temp1).SubFrontRotB();
	scArCubeSet [1] [FromFront] [0] = temp1;
	return 1;
}

{
	subcube temp;
	temp = scArCubeSet [0] [FromFront] [0];
  (scArCubeSet [2] [FromFront] [2]).SubFrontRotX();
  scArCubeSet [0] [FromFront] [0] = scArCubeSet [2] [FromFront] [2];
  temp.SubFrontRotX();
  scArCubeSet [2] [FromFront] [2] = temp;
	temp = scArCubeSet [0] [FromFront] [1];
	(scArCubeSet [2] [FromFront] [1]).SubFrontRotX();
  scArCubeSet [0] [FromFront] [1] = scArCubeSet [2] [FromFront] [1];
  temp.SubFrontRotX();
  scArCubeSet [2] [FromFront] [1] = temp;
  temp = scArCubeSet [0] [FromFront] [2];
  (scArCubeSet [2] [FromFront] [0]).SubFrontRotX();
  scArCubeSet [0] [FromFront] [2] = scArCubeSet [2] [FromFront] [0];
  temp.SubFrontRotX();
  scArCubeSet [2] [FromFront] [0] = temp;
  temp = scArCubeSet [1] [FromFront] [0];
  (scArCubeSet [1] [FromFront] [2]).SubFrontRotX();
  scArCubeSet [1] [FromFront] [0] = scArCubeSet [1] [FromFront] [2];
  temp.SubFrontRotX();
  scArCubeSet [1] [FromFront] [2] = temp;
	return 1;
}

{
	subcube temp;
	subcube temp1;
	temp = scArCubeSet [0] [0] [FromSide];
	temp1 = scArCubeSet [0] [1] [FromSide];
	(scArCubeSet [0] [2] [FromSide]).SubSideRot();
	scArCubeSet [0] [0] [FromSide] = scArCubeSet [0] [2] [FromSide];
	(scArCubeSet [1] [2] [FromSide]).SubSideRot();
	scArCubeSet [0] [1] [FromSide] = scArCubeSet [1] [2] [FromSide];
	(scArCubeSet [2] [2] [FromSide]).SubSideRot();
	scArCubeSet [0] [2] [FromSide] = scArCubeSet [2] [2] [FromSide];
	(scArCubeSet [2] [1] [FromSide]).SubSideRot();
	scArCubeSet [1] [2] [FromSide] = scArCubeSet [2] [1] [FromSide];
	(scArCubeSet [2] [0] [FromSide]).SubSideRot();
	scArCubeSet [2] [2] [FromSide] = scArCubeSet [2] [0] [FromSide];
	(scArCubeSet [1] [0] [FromSide]).SubSideRot();
	scArCubeSet [2] [1] [FromSide] = scArCubeSet [1] [0] [FromSide];
	(temp).SubSideRot();
	scArCubeSet [2] [0] [FromSide] = temp;
	(temp1).SubSideRot();
	scArCubeSet [1] [0] [FromSide] = temp1;
	return 1;
}

{
	subcube temp;
	subcube temp1;
	temp = scArCubeSet [FromTop] [0] [0];
	temp1 = scArCubeSet [FromTop] [0] [1];
	(scArCubeSet [FromTop] [2] [0]).SubTopRot();
	scArCubeSet [FromTop] [0] [0] = scArCubeSet [FromTop] [2] [0];
	(scArCubeSet [FromTop] [1] [0]).SubTopRot();
	scArCubeSet [FromTop] [0] [1] = scArCubeSet [FromTop] [1] [0];
	(scArCubeSet [FromTop] [2] [2]).SubTopRot();
	scArCubeSet [FromTop] [2] [0] = scArCubeSet [FromTop] [2] [2];
	(scArCubeSet [FromTop] [2] [1]).SubTopRot();
	scArCubeSet [FromTop] [1] [0] = scArCubeSet [FromTop] [2] [1];
	(scArCubeSet [FromTop] [0] [2]).SubTopRot();
	scArCubeSet [FromTop] [2] [2] = scArCubeSet [FromTop] [0] [2];
	(scArCubeSet [FromTop] [1] [2]).SubTopRot();
	scArCubeSet [FromTop] [2] [1] = scArCubeSet [FromTop] [1] [2];
	(temp).SubTopRot();
	scArCubeSet [FromTop] [0] [2] = temp;
	(temp1).SubTopRot();
	scArCubeSet [FromTop] [1] [2] = temp1;
	return 1;
}
{
	subcube temp;
	subcube temp1;
	temp = scArCubeSet [0] [0] [FromSide];
	temp1 = scArCubeSet [0] [1] [FromSide];
	(scArCubeSet [0] [2] [FromSide]).SubSideRotB();
	scArCubeSet [0] [0] [FromSide] = scArCubeSet [0] [2] [FromSide];
	(scArCubeSet [1] [2] [FromSide]).SubSideRotB();
	scArCubeSet [0] [1] [FromSide] = scArCubeSet [1] [2] [FromSide];
	(scArCubeSet [2] [2] [FromSide]).SubSideRotB();
	scArCubeSet [0] [2] [FromSide] = scArCubeSet [2] [2] [FromSide];
	(scArCubeSet [2] [1] [FromSide]).SubSideRotB();
	scArCubeSet [1] [2] [FromSide] = scArCubeSet [2] [1] [FromSide];
	(scArCubeSet [2] [0] [FromSide]).SubSideRotB();
	scArCubeSet [2] [2] [FromSide] = scArCubeSet [2] [0] [FromSide];
	(scArCubeSet [1] [0] [FromSide]).SubSideRotB();
	scArCubeSet [2] [1] [FromSide] = scArCubeSet [1] [0] [FromSide];
	(temp).SubSideRotB();
	scArCubeSet [2] [0] [FromSide] = temp;
	(temp1).SubSideRotB();
	scArCubeSet [1] [0] [FromSide] = temp1;
	return 1;
}
{
	subcube temp;
	temp = scArCubeSet [0] [0] [FromSide];
  (scArCubeSet [2] [2] [FromSide]).SubSideRotX();
  scArCubeSet [0] [0] [FromSide] = scArCubeSet [2] [2] [FromSide];
  temp.SubSideRotX();
  scArCubeSet [2] [2] [FromSide] = temp;
	temp = scArCubeSet [0] [1] [FromSide];
	(scArCubeSet [2] [1] [FromSide]).SubSideRotX();
  scArCubeSet [0] [1] [FromSide] = scArCubeSet [2] [1] [FromSide];
  temp.SubSideRotX();
  scArCubeSet [2] [1] [FromSide] = temp;
  temp = scArCubeSet [0] [2] [FromSide];
  (scArCubeSet [2] [0] [FromSide]).SubSideRotX();
  scArCubeSet [0] [2] [FromSide] = scArCubeSet [2] [0] [FromSide];
  temp.SubSideRotX();
  scArCubeSet [2] [0] [FromSide] = temp;
  temp = scArCubeSet [1] [0] [FromSide];
  (scArCubeSet [1] [2] [FromSide]).SubSideRotX();
  scArCubeSet [1] [0] [FromSide] = scArCubeSet [1] [2] [FromSide];
  temp.SubSideRotX();
  scArCubeSet [1] [2] [FromSide] = temp;
	return 1;
}


 double rubick::GetQualityTop(void)
{
	double q1, q3, q4, q5, q6;
	short i, j;
	double sum1, sum3, sum4, sum5, sum6;
	q1 = q3 = q4 = q5 = q6 = 0;
	sum1 = sum3 = sum4 = sum5 = sum6 = 0;
	for (i = 0;i<3;i++)
	{
		for (j = 0;j<3;j++)
		{
			sum1 += (scArCubeSet [0] [i] [j]).Rtop();
		}
	}
	for (j = 0;j<3;j++)
	{
		sum3 += (scArCubeSet [0] [0] [j]).Rfront();
		sum4 += (scArCubeSet [0] [2] [j]).Rback();
		sum5 += (scArCubeSet [0] [j] [0]).Rleft_side();
		sum6 += (scArCubeSet [0] [j] [2]).Rright_side();
	}
	sum3 += (scArCubeSet [1] [0] [1]).Rfront();
	sum4 += (scArCubeSet [1] [2] [1]).Rback();
	sum5 += (scArCubeSet [1] [1] [0]).Rleft_side();
	sum6 += (scArCubeSet [1] [1] [2]).Rright_side();
	sum1 /= 9;
	sum3 /= 4;
	sum4 /= 4;
	sum5 /= 4;
	sum6 /= 4;
	for (i = 0;i<3;i++)
	{
		for (j = 0;j<3;j++)
		{
		       q1 += fabs(sum1 - (scArCubeSet [0] [i] [j]).Rtop());
		}
	}
	for (j = 0;j<3;j++)
	{
	       q4 += fabs(sum4 - (scArCubeSet [0] [2] [j]).Rback());
	       q3 += fabs(sum3 - (scArCubeSet [0] [0] [j]).Rfront());
	       q5 += fabs(sum5 - (scArCubeSet [0] [j] [0]).Rleft_side());
	       q6 += fabs(sum6 - (scArCubeSet [0] [j] [2]).Rright_side());
	}
	q4 += fabs(sum4 - (scArCubeSet [1] [2] [1]).Rback());
	q3 += fabs(sum3 - (scArCubeSet [1] [0] [1]).Rfront());
	q5 += fabs(sum5 - (scArCubeSet [1] [1] [0]).Rleft_side());
	q6 += fabs(sum6 - (scArCubeSet [1] [1] [2]).Rright_side());

	return q1 + q3 + q4 + q5 + q6;
}
class subcube
{
public:
	void initit(short, short, short, short, short, short);
	short SubTopRot();
	short SubFrontRot();
	short SubSideRot();
	short SubTopRotB();
	short SubFrontRotB();
	short SubSideRotB();
	short SubTopRotX();
	short SubFrontRotX();
	short SubSideRotX();
	short Rtop() {return top;}
	short Rfront() {return front;}
	short Rleft_side() {return left_side;}
	short Rright_side() {return right_side;}
	short Rback() {return back;}
	short Rbottom() {return bottom;}
private:
	short top;
	short front;
	short left_side;
	short right_side;
	short back;
	short bottom;
};

(scArr [0] [0] [0]).initit(top[2][0], fro[0][0], lft[0][2], 0, 0, 0);
(scArr [0] [0] [1]).initit(top[2][1], fro[0][1], 0, 0, 0, 0);
(scArr [0] [0] [2]).initit(top[2][2], fro[0][2], 0, rt[0][0], 0, 0);
(scArr [0] [1] [0]).initit(top[1][0], 0, lft[0][1], 0, 0, 0);
(scArr [0] [1] [1]).initit(top[1][1], 0, 0, 0, 0, 0);
(scArr [0] [1] [2]).initit(top[1][2], 0, 0, rt[0][1], 0, 0);
(scArr [0] [2] [0]).initit(top[0][0], 0, lft[0][0], 0, bk[0][2], 0);
(scArr [0] [2] [1]).initit(top[0][1], 0, 0, 0, bk[0][1], 0);
(scArr [0] [2] [2]).initit(top[0][2], 0, 0, rt[0][2], bk[0][0], 0);
(scArr [1] [0] [0]).initit(0, fro[1][0], lft[1][2], 0, 0, 0);
(scArr [1] [0] [1]).initit(0, fro[1][1], 0, 0, 0, 0);
(scArr [1] [0] [2]).initit(0, fro[1][2], 0, rt[1][0], 0, 0);
(scArr [1] [1] [0]).initit(0, 0, lft[1][1], 0, 0, 0);
(scArr [1] [1] [1]).initit(0, 0, 0, 0, 0, 0);
(scArr [1] [1] [2]).initit(0, 0, 0, rt[1][1], 0, 0);
(scArr [1] [2] [0]).initit(0, 0, lft[1][0], 0, bk[1][2], 0);
(scArr [1] [2] [1]).initit(0, 0, 0, 0, bk[1][1], 0);
(scArr [1] [2] [2]).initit(0, 0, 0, rt[1][2], bk[1][0], 0);
(scArr [2] [0] [0]).initit(0, fro[2][0], lft[2][2], 0, 0, bt[0][0]);
(scArr [2] [0] [1]).initit(0, fro[2][1], 0, 0, 0, bt[0][1]);
(scArr [2] [0] [2]).initit(0, fro[2][2], 0, rt[2][0], 0, bt[0][2]);
(scArr [2] [1] [0]).initit(0, 0, lft[2][1], 0, 0, bt[1][0]);
(scArr [2] [1] [1]).initit(0, 0, 0, 0, 0, bt[1][1]);
(scArr [2] [1] [2]).initit(0, 0, 0, rt[2][1], 0, bt[1][2]);
(scArr [2] [2] [0]).initit(0, 0, lft[2][0], 0, bk[2][2], bt[2][0]);
(scArr [2] [2] [1]).initit(0, 0, 0, 0, bk[2][1], bt[2][1]);
(scArr [2] [2] [2]).initit(0, 0, 0, rt[2][2], bk[2][0], bt[2][2]);

void subcube::initit(short atop, short afront, short aleft_side, short aright_side, short aback, short abottom)
{
	top = atop;
	front = afront;
	left_side = aleft_side;
	right_side = aright_side;
	back = aback;
	bottom = abottom;
}

short subcube::SubTopRot()
{
	short temp;
	temp = left_side;
	left_side = back;
	back = right_side;
	right_side = front;
	front = temp;
	return 1;
}

short subcube::SubTopRotB()
{
  short temp = left_side;
  left_side = front;
  front = right_side;
  right_side = back;
  back = temp;
  return 1;
}

short subcube::SubTopRotX()
{
  short temp = left_side;
  left_side = right_side;
  right_side = temp;
  temp = back;
  back = front;
  front = temp;
  return 1;
}

short subcube::SubFrontRot()
{
	short temp;
	temp = top;
	top = left_side;
	left_side = bottom;
	bottom = right_side;
	right_side = temp;
	return 1;
}

short subcube::SubFrontRotB()
{
  short temp = top;
  top = right_side;
  right_side = bottom;
  bottom = left_side;
  left_side = temp;
  return 1;
}

short subcube::SubFrontRotX()
{
  short temp = top;
  top = bottom;
  bottom = temp;
  temp = right_side;
  right_side = left_side;
  left_side = temp;
  return 1;
}

short subcube::SubSideRot()
{
	short temp;
	temp = front;
	front = top;
	top = back;
	back = bottom;
	bottom = temp;
	return 1;
}

short subcube::SubSideRotB()
{
  short temp = front;
  front = bottom;
  bottom = back;
  back = top;
  top = temp;
  return 1;
}

short subcube::SubSideRotX()
{
  short temp = front;
  front = back;
  temp = bottom;
  bottom = top;
  top = temp;
  return 1;
}

ubeArray [0] [0] [0];
	scArCubeSet [0] [0] [1] = tempCubeArray [0] [0] [1];
	scArCubeSet [0] [0] [2] = tempCubeArray [0] [0] [2];
	scArCubeSet [0] [1] [0] = tempCubeArray [0] [1] [0];
	scArCubeSet [0] [1] [1] = tempCubeArray [0] [1] [1];
	scArCubeSet [0] [1] [2] = tempCubeArray [0] [1] [2];
	scArCubeSet [0] [2] [0] = tempCubeArray [0] [2] [0];
	scArCubeSet [0] [2] [1] = tempCubeArray [0] [2] [1];
	scArCubeSet [0] [2] [2] = tempCubeArray [0] [2] [2];
	scArCubeSet [1] [0] [0] = tempCubeArray [2] [0] [0];
	scArCubeSet [1] [0] [1] = tempCubeArray [3] [0] [1];
	scArCubeSet [1] [0] [2] = tempCubeArray [3] [0] [2];
	scArCubeSet [1] [1] [0] = tempCubeArray [3] [1] [0];
	scArCubeSet [1] [1] [1] = tempCubeArray [4] [1] [1];
	scArCubeSet [1] [1] [2] = tempCubeArray [4] [1] [2];
	scArCubeSet [1] [2] [0] = tempCubeArray [4] [2] [0];
	scArCubeSet [1] [2] [1] = tempCubeArray [5] [2] [1];
	scArCubeSet [1] [2] [2] = tempCubeArray [5] [2] [2];
	scArCubeSet [2] [0] [0] = tempCubeArray [5] [0] [0];
	scArCubeSet [2] [0] [1] = tempCubeArray [2] [0] [1];
	scArCubeSet [2] [0] [2] = tempCubeArray [2] [0] [2];
	scArCubeSet [2] [1] [0] = tempCubeArray [2] [1] [0];
	scArCubeSet [2] [1] [1] = tempCubeArray [2] [1] [1];
	scArCubeSet [2] [1] [2] = tempCubeArray [2] [1] [2];
	scArCubeSet [2] [2] [0] = tempCubeArray [2] [2] [0];
	scArCubeSet [2] [2] [1] = tempCubeArray [2] [2] [1];
	scArCubeSet [2] [2] [2] = tempCubeArray [2] [2] [2];

void rubick::GetArray(short * intptr)
{
  // This is easier than getting c++ to pass an array by value
  short i, j;
  short intTemp[54];
  for (i = 0; i < 3; i++)
  {
    for (j = 0; j < 3; j++)
      intTemp[3 * i + j] = cubeArray [0] [i] [j]; //right
    for (j = 0; j < 3; j++)
      intTemp[3 * i + j + 9] = cubeArray [1] [i] [j]; //left
    for (j = 0; j < 3; j++)
      intTemp[3 * i + j + 18] = cubeArray [2] [i] [j]; //front
    for (j = 0; j < 3; j++)
      intTemp[3 * i + j + 27] = cubeArray [3] [i] [j]; //top
    for (j = 0; j < 3; j++)
      intTemp[3 * i + j + 36] = cubeArray [4] [i] [j]; //back
    for (j = 0; j < 3; j++)
      intTemp[3 * i + j + 45] = cubeArray [5] [i] [j]; //bottom
  }
  for (i = 0; i < 54; i++)
  {
	  *intptr = intTemp[i];
	  intptr++;
  }
	intptr -= 54;
}

// This is easier than getting c++ to pass an array by value
for(int i = 0; i < 3; i++)
{
          for(int j = 0; j < 3; j++)
                    intTemp[3 * i + j] = tempCubeArray [0] [i] [j]; //right
          for(int j = 0; j < 3; j++)
                    intTemp[3 * i + j + 9] = tempCubeArray [1] [i] [j]; //left
          for(int j = 0; j < 3; j++)
                    intTemp[3 * i + j + 18] = tempCubeArray [2] [i] [j]; //front
          for(int j = 0; j < 3; j++)
                    intTemp[3 * i + j + 27] = tempCubeArray [3] [i] [j]; //top
          for(int j = 0; j < 3; j++)
                    intTemp[3 * i + j + 36] = tempCubeArray [4] [i] [j]; //back
          for(int j = 0; j < 3; j++)
                    intTemp[3 * i + j + 45] = tempCubeArray [5] [i] [j]; //bottom
}

          */
