//Joe Bradshaw
//0717971
//20040107
//cs500
//written in vim on RedHat Linux v9 (preparing for competition!)

#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>

using namespace std;

//function headers
void insertionSort(vector<char>&,long int);
void ShellsSort(vector<char>&,long int);
//void ShellsSort(char*,long int);
void mergeSort(vector<char>&,long int);
void binaryInsertionSort(vector<char>&,long int);
void quickSort(vector<char>&,long int,long int);
long int partition(vector<char>&,long int,long int);

int main(int argc, char* argv[])
{
	char* inputFileName = "unsorted.txt";
	if(argc == 1 || argc > 3 || strcmp(argv[argc-1],"-?")==0)
	{
		cout << "Usage: sorter {sortType} [{file2sort}]" << endl;
		cout << "sortType is:" << endl;
		cout << "1 for Shell's Sort" << endl << "2 for straight insertion sort" << endl;
		cout << "3 for binary insertion sort" << endl;
		cout << "4 for merge sort" << endl;
		cout << "5 for quicksort" << endl;
		cout << "6 for copy data to output (This allows for correction for time taken to read in and output the data)" << endl;
		exit(0);
	} 
	else if(argc == 3)
	{
		inputFileName = argv[2];
	}
	int sortType = atoi(argv[1]);
	ifstream fin;
	ofstream fout;
	fin.open(inputFileName, ios::in);
	fout.open("sorted.txt", ios::out | ios::trunc);
	vector<char> vData;
	long int iDataSize = 0;
	//Read in the data
	if(fin.good())
	{
		char latest = 0;
		latest = fin.get();
		while(!fin.eof())
		{
		//	cout << latest;	
			vData.push_back(latest);
			iDataSize++;
			latest = fin.get();
		}
	}
	//cout << "finished reading the data" << endl;
	//Sort the data
	switch(sortType)
	{
		case 1: /*cout << "Shell's Sort" << endl;*/ ShellsSort(vData,iDataSize); break;
		case 2: /*cout << "Insertion Sort" << endl;*/ insertionSort(vData,iDataSize); break; 
		case 3: /*cout << "Binary Insertion Sort" << endl;*/ binaryInsertionSort(vData,iDataSize); break;
		case 4: /*cout << "Merge Sort" << endl;*/ mergeSort(vData,iDataSize); break;
		case 5: /*cout << "Quick Sort" << endl;*/ quickSort(vData,0,iDataSize - 1); break;
		case 6: /*cout << "Doing Nothing" << endl;*/ break;
		case 7: /*cout << "Using STL Sort" << endl;*/ sort(vData.begin(),vData.end()); break;
	}
	//cout << "finished sorting the data" << endl;
	//Output the data
	for(long int index = 0;index < iDataSize; index++)
	{
		fout << vData[index];
	}
	//For reversing
	//for(int index = iDataSize - 1; index >=0; index--)
	//{
	//	fout << vData[index];
	//}
	//cout << "finished writing sorted.txt" << endl;
	fin.close();
	fout.close();
}
//Sorting functions
//Insertion
void insertionSort(vector<char>& A,long int N)
{
	char v;
	long int j;
	for(long int i = 1; i < N; i++)
	{
		v = A[i];
		j = i - 1;
		while(j >= 0 && A[j] > v)
		{
			A[j + 1] = A[j];
			j--;
		}
		A[j + 1] = v;
	}
}	
void binaryInsertionSort(vector<char>& A,long int N)
{
	char v;
	long int j;
	vector<char> vTemp(1);
	vTemp[0]=A[0];
	for(long int i = 1; i < N; i++)
	{
		v = A[i];
		j = i - 1;
		long int l = 0;
		long int r = j;
		long int m;
		while(l <= r)
		{
			m = (l + r)/2;
			if(v <= vTemp[m] && (v >= vTemp[m-1] || m-1 < 0))//found it
			{
				break;
			}
			else if(v < vTemp[m])
			{
				r = m - 1;
			}
			else
			{
				l = m + 1;
				if(l>r)
				{
					m=l;	
					break;
				}
			}	
		//while(j >= 0 && A[j] > v)
		//{
		//	A[j + 1] = A[j];
		//	j--;
		//}
		//A[j + 1] = v;
		}
		copy(A.begin() + i,A.begin() + i + 1, inserter(vTemp, vTemp.begin() + m));
//int count=0;
//for(vector<char>::iterator iter = vTemp.begin();iter != vTemp.end(); iter++)
//{
//	count++;
//	cout << (*iter);
//}
//cout << count << endl;
	}

	copy(vTemp.begin(), vTemp.end(),A.begin());
}

void ShellsSort(vector<char>& vData,long int max)
//void ShellsSort(char* aData,long int max)
{
	char * A = new char[max];
	for(int temp = 0; temp < max; temp++)
	{
		A[temp] = vData[temp];
	}
	long int j;
	long int gap = 1;
	while(gap < max)
	{
		gap = 3*gap + 1;
	}
	while(gap >= 1)
	{
		for(long int i = gap; i < max; i++)
		{
			j = i - gap;
			while(j >= 0)
			{
				if(A[j] < A[j + gap])
				{
					j = -1;
				}
				else
				{
					char v = A[j];
					A[j] = A[j + gap];
					A[j + gap] = v;
					j -= gap;
				}
			}
		}
		gap = (gap - 1)/3;
	}
	copy(A,A+max,vData.begin());
	delete[] A;
}	
void mergeSort(vector<char>& A,long int max) 
{
	//Bottom up merge sort.  Sort adjacent then adjacent pairs, etc.
	vector<char> vTemp(max);
	long int mergeSize = 1;	
	while(mergeSize <= max)
	{
		int i = 0;
		for(; i < max - 2*mergeSize + 1; i += 2*mergeSize)
		{
			merge(A.begin() + i,A.begin() + i + mergeSize, A.begin()+ i + mergeSize, A.begin() + i + 2*mergeSize, vTemp.begin() + i); 
		}
		//remaining items may need to be merged
		//if there's a mergeSize space and change the merge the two.
		//Otherwise, merge the last bit with the penultimate item.
		if(max - i > mergeSize)
		{
			merge(A.begin() + i,A.begin() + i + mergeSize,A.begin() + i + mergeSize,A.begin() + max, vTemp.begin() + i);
		}
		else if(max - i >= 1)
		{
//cout << "Merging last bits" << endl;
//cout << "Still merging" <<endl;
//long int tempInt = max;
//for(;tempInt > 0; tempInt--)
//{
//cout << A[max - tempInt];
//}
//cout << endl;
//cout << "Still here?" << endl;
			//need to copy changed data into input array
			copy(vTemp.begin() + i - 2*mergeSize, vTemp.begin() + i,A.begin() + i - 2*mergeSize);
//tempInt = max;
//for(;tempInt > max - i; tempInt--)
//{
//cout << vTemp[max - tempInt];
//}
//cout << endl;
//cout << "fixed up:" << endl;
//tempInt = max;
//for(;tempInt > 0; tempInt--)
//{
//cout << A[max - tempInt];
//}
//cout << endl;
			merge(A.begin() + i - 2*mergeSize, A.begin() + i, A.begin() + i, A.begin() + max, vTemp.begin() + i - 2*mergeSize);

		}
//cout << mergeSize << endl;
		mergeSize += mergeSize;
		//vTemp is a local variable so overwrite A
		copy(vTemp.begin(), vTemp.end(), A.begin());
//long int tempInt = max;
//for(;tempInt > 0; tempInt--)
//{
//cout << A[max - tempInt];
//}
//cout << endl;
	}
}
void quickSort(vector<char>& A,long int l, long int r) 
{
	if(l < r)
	{
		int s = partition(A,l,r);
		//cout << "(" << l << "," << s-1 << ") ";
		//cout << "(" << s+1 << "," << r << ") " << endl;
		quickSort(A,l,s-1);
		quickSort(A,s+1,r);
	}
}
long int partition(vector<char>& A,long int l, long int r)
{
	char p = A[l];
	long int i = l;
	long int j = r + 1;
	char tempChar;
	do
	{
		do
		{
			i++;
//cout << "i=" << i << ", " << endl;
		} while(i <= r && A[i] < p);
		do
		{
			j--;
//cout << "j=" << j << ", " << endl;
		} while(j >= l && A[j] > p);
		tempChar = A[i];
		A[i] = A[j];
		A[j] = tempChar;
	} while(i < j);
	tempChar = A[i];
	A[i] = A[j];
	A[j] = tempChar;
	tempChar = A[l];
	A[l] = A[j];
	A[j] = tempChar;
	return j;
}
