
import java.io.*;
import java.util.*;

public class wfind
{
	public static void main(String[] args )
	{
		if(args.length != 2 && args.length != 0)
		{
			System.err.println("The searchFile contains a rectangle of letters to be searched.  The listFile is a list of words to search for, each on a separate line.");
			throw new IllegalArgumentException("Usage: wfind [{string listFile}] [{string searchFile}]");
		}
		File listFile = new File("list.txt");
		File searchFile = new File("search.txt");
		if(args.length == 2)
		{
			listFile = new File(args[0]);
			searchFile = new File(args[1]);
		}
		try
		{
			BufferedReader in = new BufferedReader(new FileReader(searchFile));
			LineNumberReader list = new LineNumberReader(new FileReader(listFile));
			try
			{
				//Getting size of search text block		
				int i = 0;
				while('\n' != in.read())
				{
					i++;
				}
				int lineLength = i - 1;
//System.out.println("lineLength: " + lineLength);
				//This is running on windows and dealing with CRLF
				i = 2;
				in.skip(lineLength + 1);				
				while('\n' == in.read())
				{
					i++;
					in.skip(lineLength + 1);
				}
				int numLines = i;
//System.out.println("lines: " + i);
				in.close(); 
				in = new BufferedReader(new FileReader(searchFile));
				char search[][] = new char[numLines][];
				char output[][] = new char[numLines][];
				//Assign letters in search text block to matrix
				for(int h = 0; h < numLines; h++)
				{
					char line[] = new char[lineLength];
					for(int j = 0; j < lineLength; j++)
					{
						line[j] = (char) in.read();
					}
					in.read();in.read(); //get rid of the CRLF
					search[h] = line;
					output[h] = new char[lineLength];
					Arrays.fill(output[h], (char) 32); //making spaces the background character for output.
				}
				//Get list of words to find
				String aLine;
//Vector v_list = new Vector();
				while(list.ready())
				{
					aLine = list.readLine();
//v_list.add(aLine);
					for(int h = 0; h < numLines; h++)
					{
						for(int j = 0; j < lineLength; j++)
						{
							//search for first character
							if(aLine.charAt(0) == search[h][j])
							{
								int sLen = aLine.length();
								//proceed clockwise from 12 o'clock
								if(h - sLen >= -1) //check if the word could fit
								{
									for(int k = 1; k < sLen; k++)
									{
										if(search[h - k][j] != aLine.charAt(k))
											break;
										if(k == sLen - 1)//got to the end, store output
										{
											for(int l = 0; l < sLen; l++)
												output[h - l][j] = (char) (search[h - l][j]); 
										}
									}
								}
								if(h - sLen >= -1 && j + sLen <= lineLength) //1:30
								{
									for(int k = 1; k < sLen; k++)
									{
										if(search[h - k][j + k] != aLine.charAt(k))
											break;
										if(k == sLen - 1)
										{
											for(int l = 0; l < sLen; l++)
												output[h - l][j + l] = (char) (search[h - l][j + l]); 
										}
									}
								}
								if(j + sLen <= lineLength) //3:00
								{
									for(int k = 1; k < sLen; k++)
									{
										if(search[h][j + k] != aLine.charAt(k))
											break;
										if(k == sLen - 1)
										{
											for(int l = 0; l < sLen; l++)
												output[h][j + l] = (char) (search[h][j + l]); 
										}
									}
								}
								if(h + sLen <= numLines && j + sLen <= lineLength) //4:30
								{
									for(int k = 1; k < sLen; k++)
									{
										if(search[h + k][j + k] != aLine.charAt(k))
											break;
										if(k == sLen - 1)
										{
											for(int l = 0; l < sLen; l++)
												output[h + l][j + l] = (char) (search[h + l][j + l]); 
										}
									}
								}
								if(h + sLen <= numLines) //6:00
								{
									for(int k = 1; k < sLen; k++)
									{
										if(search[h + k][j] != aLine.charAt(k))
											break;
										if(k == sLen - 1)
										{
											for(int l = 0; l < sLen; l++)
												output[h + l][j] = (char) (search[h + l][j]); 
										}
									}
								}
								if(h + sLen <= numLines && j - sLen >= -1) //7:30
								{
									for(int k = 1; k < sLen; k++)
									{
										if(search[h + k][j - k] != aLine.charAt(k))
											break;
										if(k == sLen - 1)
										{
											for(int l = 0; l < sLen; l++)
												output[h + l][j - l] = (char) (search[h + l][j - l]); 
										}
									}
								}
								if(j - sLen >= -1) //9:00
								{
									for(int k = 1; k < sLen; k++)
									{
										if(search[h][j - k] != aLine.charAt(k))
											break;
										if(k == sLen - 1)
										{
											for(int l = 0; l < sLen; l++)
												output[h][j - l] = (char) (search[h][j - l]); 
										}
									}
								}
								if(h - sLen >= -1 && j - sLen >= -1) //10:30
								{
									for(int k = 1; k < sLen; k++)
									{
										if(search[h - k][j - k] != aLine.charAt(k))
											break;
										if(k == sLen - 1)
										{
											for(int l = 0; l < sLen; l++)
												output[h - l][j - l] = (char) (search[h - l][j - l]);
										}
									}
								}
							}
						}
					}
				}
				//List Find words
				//for(int s = 0; s < v_list.size(); s++)
				//{
				//	System.out.println(v_list.get(s));
				//}
				//List found words in place with spaces around them
				for(int h = 0; h < numLines; h++)
				{
					for(int j = 0; j < lineLength; j++)
					{
						System.out.print(new Character(output[h][j]));
					}
					System.out.println();
				}
			}
			catch (IOException e)
			{
				System.err.println("Error: " + e);
				e.printStackTrace();
			}
			finally
			{
				try
				{
					if(in != null)
						in.close();
					if(list !=null)
						list.close();
				}
				catch(Exception e){};
			}
		}
		catch (FileNotFoundException fnfe)
		{
			System.err.println("Error: " + fnfe);
			fnfe.printStackTrace();
		}
	}
}
